/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.binary;

import java.io.InputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApis;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.command.Constants;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApis(value={@WebApi(name="mtp/bin/GET", accepts={RequestType.REST_FORM}, methods={MethodType.GET}, overwritable=false), @WebApi(name="mtp/bin/POST", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, results={"lobId"}, overwritable=false)})
@CommandClass(name="mtp/binary/BinaryCommand", displayName="Binary Web API", overwritable=false)
public final class BinaryCommand
implements Command,
Constants {
    private static Logger logger = LoggerFactory.getLogger(BinaryCommand.class);
    public static final String PARAM_UPLOAD_FILE = "uploadFile";
    public static final String RESULT_LOB_ID = "lobId";
    DefinitionService service = DefinitionService.getInstance();
    WebApiService webApiService = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);

    public String execute(RequestContext request) {
        if (!this.webApiService.isEnableBinaryApi()) {
            logger.warn("bin web api is disabled on WebApiService configration.");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        MethodType method = (MethodType)((Object)request.getAttribute("httpMethod"));
        switch (method) {
            case GET: {
                return this.doGet(request);
            }
            case POST: {
                return this.doPost(request);
            }
        }
        throw new WebApplicationException(Response.Status.METHOD_NOT_ALLOWED);
    }

    private String doPost(RequestContext request) {
        UploadFileHandle file = request.getParamAsFile(PARAM_UPLOAD_FILE);
        BinaryReference br = file.toBinaryReference();
        request.setAttribute(RESULT_LOB_ID, (Object)br.getLobId());
        return "SUCCESS";
    }

    private String doGet(RequestContext request) {
        String subPath = (String)request.getAttribute("subPath");
        if (subPath != null && subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        long lobId = Long.parseLong(subPath);
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        BinaryReference br = em.loadBinaryReference(lobId);
        if (br == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        InputStream stream = em.getInputStream(br);
        if (stream == null) {
            logger.error("no content");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Response.ResponseBuilder rb = Response.ok((Object)stream, (String)br.getType());
        if (br.getType() != null && br.getType().length() != 0) {
            rb.type(br.getType());
        }
        if (br.getSize() != 0L) {
            rb.header("Content-Length", (Object)br.getSize());
        }
        if (br.getName() != null && br.getName().length() != 0) {
            rb.header("Content-Disposition", (Object)("attachment;filename=" + br.getName()));
        }
        request.setAttribute("result", (Object)rb);
        return "SUCCESS";
    }
}

