/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import java.io.IOException;
import java.io.InputStream;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.RestXml;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.csv.CsvUploadStatus;
import org.iplass.mtp.impl.csv.TransactionType;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.fileupload.MultiPartParameterValueMap;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="mtp/entity/POST", accepts={RequestType.REST_JSON, RequestType.REST_XML, RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="entity", parameterType=Entity.class), restXml=@RestXml(parameterName="entity"), results={"oid", "insert", "update", "delete"}, overwritable=false)
@CommandClass(name="mtp/entity/CreateEntityCommand", displayName="Entity Create Web API", overwritable=false)
public final class CreateEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_ENTITY = "entity";
    public static final String RESULT_OID = "oid";
    public static final String PARAM_UPLOAD_FILE = "uploadFile";
    public static final String PARAM_UPLOAD_UNIQUE_KEY = "uniqueKey";
    public static final String PARAM_UPLOAD_ASYNC = "asyncUpload";
    public static final String RESULT_UPLOAD_INSERT = "insert";
    public static final String RESULT_UPLOAD_UPDATE = "update";
    public static final String RESULT_UPLOAD_DELETE = "delete";

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length != 1) {
            throw new IllegalArgumentException("illegal path parameter:" + subPath);
        }
        if (this.isMultipart(request)) {
            this.doCsvUpload(request, subPath[0]);
        } else {
            this.doInsert(request, subPath[0]);
        }
        return "SUCCESS";
    }

    private boolean isMultipart(RequestContext request) {
        return request instanceof WebRequestContext && ((WebRequestContext)request).getValueMap() instanceof MultiPartParameterValueMap;
    }

    private void doInsert(RequestContext request, String defName) {
        this.checkPermission(defName, def -> def.getMetaData().isInsert());
        Entity e = (Entity)request.getAttribute(PARAM_ENTITY);
        e.setDefinitionName(defName);
        String oid = this.em.insert(e);
        request.setAttribute(RESULT_OID, (Object)oid);
    }

    private void doCsvUpload(RequestContext request, String defName) {
        block45: {
            Throwable throwable;
            InputStream is;
            this.checkPermission(defName, def -> def.getMetaData().isUpdate());
            UploadFileHandle file = request.getParamAsFile(PARAM_UPLOAD_FILE);
            String uniqueKey = StringUtil.stripToNull((String)request.getParam(PARAM_UPLOAD_UNIQUE_KEY));
            boolean async = (Boolean)request.getParam(PARAM_UPLOAD_ASYNC, Boolean.class, (Object)false);
            if (file == null) {
                throw new IllegalArgumentException("illegal parameter:uploadFile");
            }
            CsvUploadService service = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
            if (async) {
                try (InputStream is2 = file.getInputStream();){
                    service.asyncUpload(is2, file.getFileName(), defName, null, uniqueKey, false, false, false, null, null, TransactionType.ONCE, 0, true, true);
                    break block45;
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            try {
                is = file.getInputStream();
                throwable = null;
                try {
                    service.validate(is, defName, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            try {
                is = file.getInputStream();
                throwable = null;
                try {
                    CsvUploadStatus result = service.upload(is, defName, uniqueKey, false, false, false, null, null, TransactionType.ONCE, 0, true, true);
                    if (result.getStatus() != TaskStatus.COMPLETED) {
                        throw new EntityCsvException(result.getCode(), result.getMessage());
                    }
                    request.setAttribute(RESULT_UPLOAD_INSERT, (Object)result.getInsertCount());
                    request.setAttribute(RESULT_UPLOAD_UPDATE, (Object)result.getUpdateCount());
                    request.setAttribute(RESULT_UPLOAD_DELETE, (Object)result.getDeleteCount());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }
}

