/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.entity.csv.QueryWriteOption;
import org.iplass.mtp.impl.webapi.command.Constants;
import org.iplass.mtp.impl.webapi.jaxb.JaxbListValue;
import org.iplass.mtp.impl.xml.jaxb.DateXmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryXmlWriter
implements AutoCloseable,
Constants {
    private static final Logger logger = LoggerFactory.getLogger(QueryXmlWriter.class);
    private final Query query;
    private final QueryWriteOption option;
    private final EntityManager em;
    private final boolean isCountTotal;
    private DateXmlAdapter dateAdapter;
    private Marshaller marshaller;
    private XMLStreamWriter writer;
    private Map<String, String> nameSpaceList;

    public QueryXmlWriter(OutputStream out, Query query, boolean isCountTotal, JAXBContext context, Map<String, String> nameSpaceMap, DateXmlAdapter dateAdapter) throws IOException {
        this(out, query, isCountTotal, new QueryWriteOption(), context, nameSpaceMap, dateAdapter);
    }

    public QueryXmlWriter(OutputStream out, Query query, boolean isCountTotal, QueryWriteOption option, JAXBContext context, Map<String, String> nameSpaceList, DateXmlAdapter dateAdapter) throws IOException {
        this.query = query;
        this.isCountTotal = isCountTotal;
        this.option = option;
        this.dateAdapter = dateAdapter;
        this.nameSpaceList = nameSpaceList;
        this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            this.marshaller = context.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            this.writer = factory.createXMLStreamWriter(new BufferedWriter(new OutputStreamWriter(out, option.getCharset())));
        }
        catch (JAXBException | XMLStreamException e) {
            throw new SystemException(e);
        }
    }

    public void write() throws IOException {
        try {
            this.writer.writeProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"");
            this.writer.writeStartElement("webapi", "webApiResponse", "http://mtp.iplass.org/xml/webapi");
            for (Map.Entry<String, String> entry : this.nameSpaceList.entrySet()) {
                this.writer.writeNamespace(entry.getKey(), entry.getValue());
            }
            this.writer.writeStartElement("status");
            this.writer.writeCharacters("SUCCESS");
            this.writer.writeEndElement();
            Query optQuery = (Query)this.option.getBeforeSearch().apply(this.query);
            this.writer.writeStartElement("result");
            this.writer.writeAttribute("key", "listHeader");
            this.writer.writeStartElement("value");
            ArrayList<Object> headerList = new ArrayList<Object>(optQuery.getSelect().getSelectValues().size());
            for (ValueExpression ve : optQuery.getSelect().getSelectValues()) {
                headerList.add(ve.toString());
            }
            JAXBElement root = new JAXBElement(new QName("http://mtp.iplass.org/xml/webapi", "list"), JaxbListValue.class, (Object)new JaxbListValue(headerList));
            this.marshaller.marshal((Object)root, this.writer);
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeStartElement("result");
            this.writer.writeAttribute("key", "list");
            this.writer.writeStartElement("value");
            int countTotal = this.search(optQuery);
            this.writer.writeEndElement();
            if (this.isCountTotal) {
                this.writer.writeEndElement();
                this.writer.writeStartElement("result");
                this.writer.writeAttribute("key", "count");
                this.writer.writeStartElement("value");
                this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.writer.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                this.writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xs:int");
                this.writer.writeCharacters(String.valueOf(countTotal));
            }
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new SystemException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (XMLStreamException e) {
                logger.warn("fail to close QueryXmlWriter resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.writer = null;
        }
    }

    private void writeValues(Object[] values) {
        ArrayList<Object> vList = new ArrayList<Object>(values.length);
        try {
            for (Object lv : values) {
                vList.add(this.dateAdapter.marshal(lv));
            }
            JAXBElement root = new JAXBElement(new QName("http://mtp.iplass.org/xml/webapi", "list"), JaxbListValue.class, (Object)new JaxbListValue(vList));
            this.marshaller.marshal((Object)root, this.writer);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private int search(final Query optQuery) {
        if (this.option.getLimit() > 0) {
            optQuery.setLimit(new Limit(this.option.getLimit()));
        }
        final int[] count = new int[1];
        this.em.search(optQuery, (Predicate)new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] values) {
                QueryXmlWriter.this.option.getAfterSearch().accept(optQuery.copy(), values);
                QueryXmlWriter.this.writeValues(values);
                count[0] = count[0] + 1;
                return true;
            }
        });
        return count[0];
    }
}

