/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.rest.LimitRequestBodyInputStream;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
public class MtpContainerRequestFilter
implements ContainerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(MtpContainerRequestFilter.class);
    private WebApiService apiservice = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        RequestPath path = new RequestPath(requestContext.getUriInfo().getPath(), (RequestPath)requestContext.getProperty("mtp.requestPath"));
        requestContext.setProperty("mtp.requestPath", (Object)path);
        String webApiName = path.getTargetPath(true);
        MetaWebApi.WebApiRuntime runtime = this.apiservice.getByPathHierarchy(webApiName, requestContext.getMethod());
        if (runtime == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(webApiName + " not defined path.");
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        runtime.checkMethodType(requestContext.getMethod());
        MediaType mt = requestContext.getMediaType();
        runtime.checkContentType(mt);
        if (MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mt)) {
            if (runtime.getRequestRestriction().maxBodySize() != -1L) {
                requestContext.setProperty("mtp.restRequestContext.maxBodySize", (Object)runtime.getRequestRestriction().maxBodySize());
            }
        } else if (requestContext.hasEntity() && runtime.getRequestRestriction().maxBodySize() != -1L) {
            requestContext.setEntityStream((InputStream)new LimitRequestBodyInputStream(requestContext.getEntityStream(), runtime.getRequestRestriction().maxBodySize(), requestContext.getLength()));
            requestContext.setProperty("mtp.restRequestContext.maxBodySize", (Object)runtime.getRequestRestriction().maxBodySize());
        }
        requestContext.setProperty("mtp.restRequestContext.webApiRuntime", (Object)runtime);
    }
}

