/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.oauth.definition.OAuthAuthorizationDefinition;
import org.iplass.mtp.auth.oauth.definition.OAuthAuthorizationDefinitionManager;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCodeStore;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtKeyStore;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;
import org.iplass.mtp.impl.auth.oauth.token.OAuthAccessTokenStore;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class OAuthAuthorizationService
extends AbstractTypedMetaDataService<MetaOAuthAuthorization, MetaOAuthAuthorization.OAuthAuthorizationRuntime>
implements Service {
    public static final String OAUTH_AUTHZ_PATH = "/oauth/authZ/";
    public static final String DEFAULT_NAME = "DEFAULT";
    private boolean paramStateRequired = true;
    private boolean paramNonceRequired = false;
    private boolean forceS256ForCodeChallengeMethod = true;
    private boolean forcePKCE = true;
    private String defaultConsentTemplateName;
    private AuthorizationCodeStore authorizationCodeStore;
    private OAuthAccessTokenStore accessTokenStore;
    private JwtProcessor jwtProcessor;
    private JwtKeyStore jwtKeyStore;
    private String subjectIdHashAlgorithm;
    private String subjectIdHashSalt;
    private long idTokenLifetimeSeconds = 3600L;

    public long getIdTokenLifetimeSeconds() {
        return this.idTokenLifetimeSeconds;
    }

    public JwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    public JwtKeyStore getJwtKeyStore() {
        return this.jwtKeyStore;
    }

    public String getDefaultConsentTemplateName() {
        return this.defaultConsentTemplateName;
    }

    public boolean isForcePKCE() {
        return this.forcePKCE;
    }

    public boolean isForceS256ForCodeChallengeMethod() {
        return this.forceS256ForCodeChallengeMethod;
    }

    public boolean isParamNonceRequired() {
        return this.paramNonceRequired;
    }

    public boolean isParamStateRequired() {
        return this.paramStateRequired;
    }

    public String getSubjectIdHashAlgorithm() {
        return this.subjectIdHashAlgorithm;
    }

    public String getSubjectIdHashSalt() {
        return this.subjectIdHashSalt;
    }

    public static String getFixedPath() {
        return OAUTH_AUTHZ_PATH;
    }

    public Class<MetaOAuthAuthorization> getMetaDataType() {
        return MetaOAuthAuthorization.class;
    }

    public Class<MetaOAuthAuthorization.OAuthAuthorizationRuntime> getRuntimeType() {
        return MetaOAuthAuthorization.OAuthAuthorizationRuntime.class;
    }

    public void init(Config config) {
        this.paramStateRequired = (Boolean)config.getValue("paramStateRequired", Boolean.TYPE, (Object)Boolean.TRUE);
        this.paramNonceRequired = (Boolean)config.getValue("paramNonceRequired", Boolean.TYPE, (Object)Boolean.FALSE);
        this.forceS256ForCodeChallengeMethod = (Boolean)config.getValue("forceS256ForCodeChallengeMethod", Boolean.TYPE, (Object)Boolean.TRUE);
        this.forcePKCE = (Boolean)config.getValue("forcePKCE", Boolean.TYPE, (Object)Boolean.TRUE);
        this.defaultConsentTemplateName = config.getValue("defaultConsentTemplateName");
        this.authorizationCodeStore = (AuthorizationCodeStore)config.getValue("authorizationCodeStore", AuthorizationCodeStore.class);
        this.accessTokenStore = (OAuthAccessTokenStore)config.getValue("accessTokenStore", OAuthAccessTokenStore.class);
        this.subjectIdHashAlgorithm = config.getValue("subjectIdHashAlgorithm");
        this.subjectIdHashSalt = config.getValue("subjectIdHashSalt");
        this.jwtProcessor = (JwtProcessor)config.getValue("jwtProcessor", JwtProcessor.class);
        this.jwtKeyStore = (JwtKeyStore)config.getValue("jwtKeyStore", JwtKeyStore.class);
        this.idTokenLifetimeSeconds = (Long)config.getValue("idTokenLifetimeSeconds", Long.TYPE, (Object)3600L);
        if (this.subjectIdHashAlgorithm != null) {
            try {
                MessageDigest.getInstance(this.subjectIdHashAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServiceConfigrationException("invalid subjectIdHashAlgorithm", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public MetaOAuthAuthorization.OAuthAuthorizationRuntime getOrDefault(String defName) {
        if (defName == null) {
            defName = DEFAULT_NAME;
        }
        return (MetaOAuthAuthorization.OAuthAuthorizationRuntime)MetaDataContext.getContext().getMetaDataHandler(MetaOAuthAuthorization.OAuthAuthorizationRuntime.class, OAUTH_AUTHZ_PATH + defName);
    }

    public OAuthAccessTokenStore getAccessTokenStore() {
        return this.accessTokenStore;
    }

    public AuthorizationCodeStore getAuthorizationCodeStore() {
        return this.authorizationCodeStore;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<OAuthAuthorizationDefinition, MetaOAuthAuthorization> {
        public TypeMap() {
            super(OAuthAuthorizationService.getFixedPath(), MetaOAuthAuthorization.class, OAuthAuthorizationDefinition.class);
        }

        public TypedDefinitionManager<OAuthAuthorizationDefinition> typedDefinitionManager() {
            return (TypedDefinitionManager)ManagerLocator.getInstance().getManager(OAuthAuthorizationDefinitionManager.class);
        }
    }
}

