/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueRefreshToken;

public class OpaqueAccessToken
extends AccessToken {
    private String series;
    private String tokenEncoded;
    private long expires;
    private long expiresIn;
    private User user;
    private List<String> grantedScopes;
    private String clientId;
    private long creationTime;
    private RefreshToken refreshToken;

    public OpaqueAccessToken(MetaOAuthClient.OAuthClientRuntime client, AccessTokenMement mement, String series, String tokenEncoded, long creationTime, OpaqueRefreshToken refreshToken) {
        this.series = series;
        this.tokenEncoded = tokenEncoded;
        this.expires = mement.getExpires();
        this.expiresIn = (this.expires - System.currentTimeMillis()) / 1000L;
        this.user = mement.getUser();
        this.refreshToken = refreshToken;
        this.clientId = client.getMetaData().getName();
        this.creationTime = creationTime;
        this.grantedScopes = new ArrayList<String>();
        MetaOAuthAuthorization.OAuthAuthorizationRuntime server = client.getAuthorizationServer();
        List<String> scopesByClientType = server.getClientPolicy(client.getMetaData().getClientType()).scopeList();
        for (String s : mement.getGrantedScopes()) {
            if (!scopesByClientType.contains(s)) continue;
            this.grantedScopes.add(s);
        }
    }

    public String getSeries() {
        return this.series;
    }

    @Override
    public List<String> getGrantedScopes() {
        return this.grantedScopes;
    }

    @Override
    public String getTokenEncoded() {
        return this.tokenEncoded;
    }

    @Override
    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public long getExpirationTime() {
        return TimeUnit.MILLISECONDS.toSeconds(this.expires);
    }

    @Override
    public long getIssuedAt() {
        return TimeUnit.MILLISECONDS.toSeconds(this.creationTime);
    }

    @Override
    public long getNotBefore() {
        return TimeUnit.MILLISECONDS.toSeconds(this.creationTime);
    }
}

