/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.util.ArrayList;
import java.util.HashSet;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenHandler;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueRefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.TokenCreationStrategy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameTokenCreationStrategy
implements TokenCreationStrategy {
    private static Logger logger = LoggerFactory.getLogger(SameTokenCreationStrategy.class);
    private long retryIntervalMillis;
    private int retryCount;

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public void setRetryIntervalMillis(long retryIntervalMillis) {
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    @Override
    public AuthToken create(MetaOAuthClient.OAuthClientRuntime client, AccessTokenHandler handler, String userUniqueId, AccessTokenInfo accessTokenInfo) {
        if (handler.getHashSettings() != null && handler.getHashSettings().size() > 0) {
            throw new SystemException("SameTokenCreationStrategy is not support AuthToken hash setting.");
        }
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String series = handler.newSeriesString(userUniqueId, null, accessTokenInfo);
        for (int i = 0; i <= this.retryCount; ++i) {
            AuthToken at = null;
            try {
                at = (AuthToken)Transaction.requiresNew(t -> {
                    AuthToken storeToken = handler.authTokenStore().getBySeries(tenantId, handler.getType(), series);
                    if (storeToken == null) {
                        AuthToken newToken = handler.newAuthToken(userUniqueId, null, accessTokenInfo);
                        handler.authTokenStore().create(newToken);
                        return newToken;
                    }
                    AccessTokenMement atm = (AccessTokenMement)storeToken.getDetails();
                    if (!atm.getResouceOwnerId().equals(userUniqueId) || !client.getMetaData().getId().equals(atm.getClientMetaDataId())) {
                        throw new SystemException("AccessToken's series hash may have collision: client=" + atm.getClientMetaDataId() + " ,series=" + series);
                    }
                    if (atm.getGrantedScopes() == null || !atm.getGrantedScopes().containsAll(accessTokenInfo.getGrantedScopes())) {
                        HashSet<String> mergedScopes = new HashSet<String>();
                        if (atm.getGrantedScopes() != null) {
                            mergedScopes.addAll(atm.getGrantedScopes());
                        }
                        mergedScopes.addAll(accessTokenInfo.getGrantedScopes());
                        AccessTokenInfo mergedAccessTokenInfo = new AccessTokenInfo();
                        mergedAccessTokenInfo.setClientName(accessTokenInfo.getClientName());
                        mergedAccessTokenInfo.setGrantedScopes(new ArrayList<String>(mergedScopes));
                        handler.authTokenStore().deleteBySeries(tenantId, handler.getType(), series);
                        AuthToken newToken = handler.newAuthToken(userUniqueId, null, mergedAccessTokenInfo);
                        handler.authTokenStore().create(newToken);
                        return newToken;
                    }
                    AuthToken retToken = null;
                    if (atm.getExpires() > System.currentTimeMillis()) {
                        retToken = storeToken;
                    } else {
                        AccessTokenInfo newAccessTokenInfo = new AccessTokenInfo();
                        newAccessTokenInfo.setClientName(client.getMetaData().getName());
                        newAccessTokenInfo.setGrantedScopes(new ArrayList<String>(atm.getGrantedScopes()));
                        AuthToken newToken = handler.newAuthToken(userUniqueId, null, newAccessTokenInfo);
                        handler.authTokenStore().update(newToken, storeToken);
                        retToken = newToken;
                    }
                    AccessTokenMement retTokenMement = (AccessTokenMement)retToken.getDetails();
                    boolean needRefreshToken = false;
                    MetaOAuthAuthorization.OAuthAuthorizationRuntime authorizationServer = null;
                    if (accessTokenInfo.getGrantedScopes().contains("offline_access") && (authorizationServer = client.getAuthorizationServer()).getClientPolicy(client.getMetaData().getClientType()).isRequireRefreshToken(accessTokenInfo.getGrantedScopes())) {
                        needRefreshToken = true;
                    }
                    if (needRefreshToken && retTokenMement.getRefreshToken() == null) {
                        retTokenMement.setRefreshToken(handler.refreshTokenHandler().authTokenStore().getBySeries(tenantId, handler.refreshTokenHandler().getType(), retToken.getSeries()));
                    }
                    if (needRefreshToken && (retTokenMement.getRefreshToken() == null || ((RefreshTokenMement)retTokenMement.getRefreshToken().getDetails()).getExpires() <= System.currentTimeMillis())) {
                        handler.refreshTokenHandler().authTokenStore().deleteBySeries(tenantId, handler.refreshTokenHandler().getType(), retToken.getSeries());
                        AuthToken refreshToken = handler.refreshTokenHandler().newAuthToken(retToken.getOwnerId(), retToken.getPolicyName(), new RefreshTokenMement.RefreshTokenInfo(client.getMetaData().getName()));
                        handler.refreshTokenHandler().authTokenStore().create(refreshToken);
                        retTokenMement.setRefreshToken(refreshToken);
                    }
                    return retToken;
                });
            }
            catch (RuntimeException e) {
                if (i == this.retryCount) {
                    throw e;
                }
                logger.warn("AuthToken:" + series + " update failed, do re-try...", (Throwable)e);
            }
            if (at != null) {
                return at;
            }
            try {
                Thread.sleep(this.retryIntervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                throw new SystemException("thread is interrupted.", (Throwable)e);
            }
        }
        throw new SystemException("Can not create AuthToken:" + series + ". retry count over");
    }

    @Override
    public AuthToken create(MetaOAuthClient.OAuthClientRuntime client, AccessTokenHandler handler, OpaqueRefreshToken refreshToken) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String series = refreshToken.getSeries();
        for (int i = 0; i <= this.retryCount; ++i) {
            AuthToken at = null;
            try {
                at = (AuthToken)Transaction.requiresNew(t -> {
                    AuthToken storeToken = handler.authTokenStore().getBySeries(tenantId, handler.getType(), series);
                    if (storeToken == null) {
                        return null;
                    }
                    AccessTokenMement atm = (AccessTokenMement)storeToken.getDetails();
                    if (!client.getMetaData().getId().equals(atm.getClientMetaDataId())) {
                        throw new SystemException("AccessToken's series hash may have collision: client=" + atm.getClientMetaDataId() + " ,series=" + series);
                    }
                    if (atm.getExpires() > System.currentTimeMillis()) {
                        return storeToken;
                    }
                    AccessTokenInfo newAccessTokenInfo = new AccessTokenInfo();
                    newAccessTokenInfo.setClientName(client.getMetaData().getName());
                    newAccessTokenInfo.setGrantedScopes(new ArrayList<String>(atm.getGrantedScopes()));
                    AuthToken newToken = handler.newAuthToken(storeToken.getOwnerId(), null, newAccessTokenInfo);
                    handler.authTokenStore().update(newToken, storeToken);
                    return newToken;
                });
            }
            catch (RuntimeException e) {
                if (i == this.retryCount) {
                    throw e;
                }
                logger.warn("AuthToken:" + series + " update failed, do re-try...", (Throwable)e);
            }
            if (at != null) {
                return at;
            }
            try {
                Thread.sleep(this.retryIntervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                throw new SystemException("thread is interrupted.", (Throwable)e);
            }
        }
        throw new SystemException("Can not refresh AuthToken:" + series + ". retry count over");
    }
}

