/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.util.concurrent.ConcurrentHashMap;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;

public class JxlsCompiledScriptCacheStore {
    private ScriptEngine se;
    private ConcurrentHashMap<String, Script> jxlsCompiledScriptCache;
    private String templateName;
    private static final String SCRIPT_PREFIX = "JxlsGroovyEvaluator_script";

    public JxlsCompiledScriptCacheStore(String templateName) {
        TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
        this.se = tc.getScriptEngine();
        this.jxlsCompiledScriptCache = new ConcurrentHashMap();
        this.templateName = templateName;
    }

    public Script getScript(String expression) {
        Script script = this.jxlsCompiledScriptCache.get(expression);
        if (script == null && this.templateName != null) {
            script = this.se.createScript(expression, "JxlsGroovyEvaluator_script_" + this.templateName + "_" + GroovyTemplateCompiler.randomName());
            this.jxlsCompiledScriptCache.put(expression, script);
        }
        return script;
    }
}

