/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;
import org.iplass.mtp.impl.report.JxlsCompiledScriptCacheStore;
import org.iplass.mtp.impl.report.JxlsGroovyEvaluator;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.web.template.report.MetaJxlsReportOutputLogic;
import org.iplass.mtp.impl.web.template.report.MetaReportParamMap;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.report.definition.OutputFileType;
import org.jxls.common.Context;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxlsReportingOutputModel
implements ReportingOutputModel {
    private static Logger logger = LoggerFactory.getLogger(JxlsReportingOutputModel.class);
    private String passwordAttributeName;
    private POIFSFileSystem fs;
    private File tempPasswordFile;
    private MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime logicRuntime;
    private byte[] binary;
    private String type;
    private MetaReportParamMap[] paramMap;
    private JxlsCompiledScriptCacheStore cacheStore;

    JxlsReportingOutputModel(byte[] binary, String type, String extension) throws Exception {
        this.binary = binary;
        this.type = type;
    }

    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime getLogicRuntime() {
        return this.logicRuntime;
    }

    public void setLogicRuntime(MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime logicRuntime) {
        this.logicRuntime = logicRuntime;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MetaReportParamMap[] getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(MetaReportParamMap[] paramMap) {
        this.paramMap = paramMap;
    }

    public JxlsCompiledScriptCacheStore getCacheStore() {
        return this.cacheStore;
    }

    public void setCacheStore(JxlsCompiledScriptCacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    public void write(Context context, OutputStream os, String password) throws IOException, InvalidFormatException, GeneralSecurityException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.getBinary());){
            JxlsHelper jxlsHelper = JxlsHelper.getInstance();
            JxlsGroovyEvaluator evaluator = new JxlsGroovyEvaluator(this.cacheStore);
            OutputFileType outputType = OutputFileType.convertOutputFileType(this.getType());
            if (StringUtil.isEmpty((String)password)) {
                this.outputReport(this.getTransformer(jxlsHelper, is, os, evaluator), context, jxlsHelper);
            } else if (OutputFileType.XLS_JXLS.equals((Object)outputType)) {
                logger.warn("XLS type does not support encryption. IF you want to encryption, change to XLSX type.");
                this.outputReport(this.getTransformer(jxlsHelper, is, os, evaluator), context, jxlsHelper);
            } else {
                this.getPOIFSFileSystem(context, is, jxlsHelper, password, evaluator).writeFilesystem(os);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fs != null) {
                this.fs.close();
                this.fs = null;
            }
        }
        finally {
            if (this.tempPasswordFile != null) {
                if (!this.tempPasswordFile.delete()) {
                    logger.warn("Fail to delete temporary resource:" + this.tempPasswordFile.getPath());
                }
                this.tempPasswordFile = null;
            }
        }
    }

    private POIFSFileSystem getPOIFSFileSystem(Context context, InputStream is, JxlsHelper jxlsHelper, String password, ExpressionEvaluator evaluator) throws IOException, InvalidFormatException, GeneralSecurityException {
        if (this.fs != null) {
            return this.fs;
        }
        this.tempPasswordFile = TempFile.createTempFile((String)"tmp", (String)".tmp");
        try (FileOutputStream fos = new FileOutputStream(this.tempPasswordFile);){
            this.outputReport(this.getTransformer(jxlsHelper, is, fos, evaluator), context, jxlsHelper);
        }
        this.fs = new POIFSFileSystem();
        EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
        Encryptor enc = info.getEncryptor();
        enc.confirmPassword(password);
        try (OPCPackage opc = OPCPackage.open((File)this.tempPasswordFile, (PackageAccess)PackageAccess.READ_WRITE);
             OutputStream encos = enc.getDataStream(this.fs);){
            opc.save(encos);
        }
        return this.fs;
    }

    private void outputReport(Transformer transformer, Context context, JxlsHelper jxlsHelper) throws IOException {
        if (this.getLogicRuntime() != null) {
            this.logicRuntime.outputReport(transformer, context);
        } else {
            jxlsHelper.processTemplate(context, transformer);
        }
    }

    private Transformer getTransformer(JxlsHelper jxlsHelper, InputStream is, OutputStream os, ExpressionEvaluator evaluator) {
        Transformer transformer = jxlsHelper.createTransformer(is, os);
        transformer.getTransformationConfig().setExpressionEvaluator(evaluator);
        return transformer;
    }
}

