/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.web.ParameterValueMap;
import org.iplass.mtp.impl.web.ReadOnlyHttpServletRequest;
import org.iplass.mtp.impl.web.ResponseHeaderImpl;
import org.iplass.mtp.impl.web.SimpleParameterValueMap;
import org.iplass.mtp.impl.web.SimpleSessionContext;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.fileupload.MultiPartParameterValueMap;
import org.iplass.mtp.spi.ServiceRegistry;

public class WebRequestContext
implements RequestContext {
    public static final String MARK_USE_OUTPUT_STREAM = "org.iplass.mtp.markUseOutputStream";
    private ParameterValueMap valueMap;
    private HttpServletRequest servletRequest;
    protected SimpleSessionContext session;
    private ReadOnlyHttpServletRequest readOnlyServletRequest;
    private Map<String, Object> httpHeader;
    private Map<String, Object> paramMap;

    public WebRequestContext(ServletContext servletContext, HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            this.setValueMap(new MultiPartParameterValueMap(servletContext, servletRequest));
        } else {
            this.setValueMap(new SimpleParameterValueMap(servletRequest));
        }
    }

    private ReadOnlyHttpServletRequest getReadOnlyHttpServletRequest() {
        if (this.readOnlyServletRequest == null && this.servletRequest != null) {
            this.readOnlyServletRequest = new ReadOnlyHttpServletRequest(this.servletRequest);
        }
        return this.readOnlyServletRequest;
    }

    private Map<String, Object> getHttpHeader() {
        if (this.httpHeader == null) {
            if (this.servletRequest != null) {
                Enumeration headerNames = this.servletRequest.getHeaderNames();
                HashMap<String, Object> header = new HashMap<String, Object>();
                ArrayList<String> buf = new ArrayList<String>();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    Enumeration headerValues = this.servletRequest.getHeaders(name);
                    while (headerValues.hasMoreElements()) {
                        buf.add((String)headerValues.nextElement());
                    }
                    if (buf.size() == 1) {
                        header.put(name, buf.get(0));
                    } else if (buf.size() > 1) {
                        header.put(name, buf.toArray(new String[buf.size()]));
                    }
                    buf.clear();
                }
                this.httpHeader = Collections.unmodifiableMap(header);
            } else {
                this.httpHeader = Collections.emptyMap();
            }
        }
        return this.httpHeader;
    }

    public void setValueMap(ParameterValueMap valueMap) {
        this.valueMap = valueMap;
        this.paramMap = null;
    }

    public ParameterValueMap getValueMap() {
        return this.valueMap;
    }

    public Iterator<String> getAttributeNames() {
        final Enumeration e = this.servletRequest.getAttributeNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)e.nextElement();
            }
        };
    }

    public void finallyProcess() {
        if (this.valueMap != null) {
            this.valueMap.cleanTempResource();
        }
        if (this.session != null && this.session.isUpdate()) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            SessionService ss = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class);
            Session s = ss.getSession(true);
            this.session.resetUpdateFlag();
            s.setAttribute("org.iplass.mtp.sessionContext." + tenantId, (Object)this.session);
        }
    }

    public Object getAttribute(String name) {
        switch (name) {
            case "header": {
                return this.getHttpHeader();
            }
            case "param": {
                return this.getParamMap();
            }
            case "responseHeader": {
                return new ResponseHeaderImpl();
            }
            case "servletRequest": {
                return this.getReadOnlyHttpServletRequest();
            }
            case "action": {
                return Boolean.TRUE;
            }
            case "actionName": 
            case "commandResult": 
            case "executedCommand": 
            case "mtp.web.exception": {
                return WebRequestStack.getCurrent().getAttribute(name);
            }
            case "subPath": {
                WebRequestStack stack = WebRequestStack.getCurrent();
                String actName = (String)stack.getAttribute("actionName");
                if (actName == null) {
                    return null;
                }
                return stack.getRequestPath().getTargetSubPath(actName, true);
            }
        }
        return this.servletRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        switch (name) {
            case "header": 
            case "param": 
            case "responseHeader": 
            case "servletRequest": 
            case "action": 
            case "actionName": 
            case "executedCommand": {
                throw new IllegalArgumentException(name + " is ReadOnly attribute.");
            }
            case "commandResult": 
            case "mtp.web.exception": {
                WebRequestStack.getCurrent().setAttribute(name, value);
            }
        }
        this.servletRequest.setAttribute(name, value);
    }

    protected void setAttributeDirect(String name, Object value) {
        this.servletRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.servletRequest.removeAttribute(name);
    }

    public Map<String, Object> getParamMap() {
        if (this.paramMap == null) {
            this.paramMap = this.valueMap != null ? Collections.unmodifiableMap(this.valueMap.getParamMap()) : Collections.emptyMap();
        }
        return this.paramMap;
    }

    public Iterator<String> getParamNames() {
        if (this.valueMap != null) {
            return this.valueMap.getParamNames();
        }
        return Collections.emptyIterator();
    }

    public String getParam(String name) {
        if (this.valueMap != null) {
            Object val = this.valueMap.getParam(name);
            if (val == null) {
                return null;
            }
            return val.toString();
        }
        return null;
    }

    public String[] getParams(String name) {
        if (this.valueMap != null) {
            Object[] vals = this.valueMap.getParams(name);
            if (vals == null) {
                return null;
            }
            if (vals instanceof String[]) {
                return (String[])vals;
            }
            String[] ret = new String[vals.length];
            for (int i = 0; i < ret.length; ++i) {
                if (vals[i] == null) continue;
                ret[i] = vals[i].toString();
            }
            return ret;
        }
        return null;
    }

    public UploadFileHandle getParamAsFile(String name) {
        if (this.valueMap != null) {
            Object val = this.valueMap.getParam(name);
            if (val instanceof UploadFileHandle) {
                return (UploadFileHandle)val;
            }
            return null;
        }
        return null;
    }

    public UploadFileHandle[] getParamsAsFile(String name) {
        if (this.valueMap != null) {
            Object[] vals = this.valueMap.getParams(name);
            if (vals instanceof UploadFileHandle[]) {
                return (UploadFileHandle[])vals;
            }
            return null;
        }
        return null;
    }

    public SessionContext getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContext getSession(boolean create) {
        SessionService ss;
        Session s;
        if (this.session == null && (s = (ss = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class)).getSession(create)) != null) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            this.session = (SimpleSessionContext)s.getAttribute("org.iplass.mtp.sessionContext." + tenantId);
            if (this.session == null) {
                Object object = s.getSessionMutexObject();
                synchronized (object) {
                    this.session = (SimpleSessionContext)s.getAttribute("org.iplass.mtp.sessionContext." + tenantId);
                    if (this.session == null) {
                        this.session = new SimpleSessionContext();
                        s.setAttribute("org.iplass.mtp.sessionContext." + tenantId, (Object)this.session);
                    }
                }
            }
        }
        return this.session;
    }

    public void clearSession() {
        this.session = null;
    }
}

