/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.DynamicTemplateResult;
import org.iplass.mtp.impl.web.actionmapping.RedirectResult;
import org.iplass.mtp.impl.web.actionmapping.StaticResourceResult;
import org.iplass.mtp.impl.web.actionmapping.StreamResult;
import org.iplass.mtp.impl.web.actionmapping.TemplateResult;
import org.iplass.mtp.web.actionmapping.definition.result.DynamicTemplateResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.RedirectResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.StaticResourceResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.StreamResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.TemplateResultDefinition;

@XmlSeeAlso(value={RedirectResult.class, DynamicTemplateResult.class, StreamResult.class, TemplateResult.class, StaticResourceResult.class})
public abstract class Result
implements MetaData {
    private static final long serialVersionUID = 6043623303625555566L;
    private String commandResultStatus;
    private String exceptionClassName;

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public String getCommandResultStatus() {
        return this.commandResultStatus;
    }

    public void setCommandResultStatus(String commandResultStatus) {
        this.commandResultStatus = commandResultStatus;
    }

    public static Result createInstance(ResultDefinition definition) {
        if (definition instanceof DynamicTemplateResultDefinition) {
            return new DynamicTemplateResult();
        }
        if (definition instanceof RedirectResultDefinition) {
            return new RedirectResult();
        }
        if (definition instanceof StreamResultDefinition) {
            return new StreamResult();
        }
        if (definition instanceof TemplateResultDefinition) {
            return new TemplateResult();
        }
        if (definition instanceof StaticResourceResultDefinition) {
            return new StaticResourceResult();
        }
        return null;
    }

    public abstract void applyConfig(ResultDefinition var1);

    public abstract ResultDefinition currentConfig();

    protected void fillFrom(ResultDefinition definition) {
        this.commandResultStatus = definition.getCommandResultStatus();
        this.exceptionClassName = definition.getExceptionClassName();
    }

    protected void fillTo(ResultDefinition definition) {
        definition.setCommandResultStatus(this.commandResultStatus);
        definition.setExceptionClassName(this.exceptionClassName);
    }

    public abstract ResultRuntime createRuntime();

    public Result copy() {
        return (Result)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public abstract class ResultRuntime {
        public abstract void handle(WebRequestStack var1) throws ServletException, IOException;

        public abstract Result getMetaData();

        public abstract void finallyProcess(WebRequestStack var1);
    }
}

