/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.web.actionmapping.definition.cache.CacheCriteriaDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.ScriptingCacheCriteriaDefinition;

public class MetaScriptingCacheCriteria
extends MetaCacheCriteria {
    private static final long serialVersionUID = -8948760695898972341L;
    private static final String REQUEST_BINDING_NAME = "request";
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public void applyConfig(CacheCriteriaDefinition definition) {
        this.fillFrom(definition);
        ScriptingCacheCriteriaDefinition def = (ScriptingCacheCriteriaDefinition)definition;
        this.script = def.getScript();
    }

    @Override
    public CacheCriteriaDefinition currentConfig() {
        ScriptingCacheCriteriaDefinition definition = new ScriptingCacheCriteriaDefinition();
        this.fillTo(definition);
        definition.setScript(this.script);
        return definition;
    }

    @Override
    public ScriptingCacheCriteriaRuntime createRuntime(MetaActionMapping actionMapping) {
        return new ScriptingCacheCriteriaRuntime(actionMapping);
    }

    public class ScriptingCacheCriteriaRuntime
    extends MetaCacheCriteria.CacheCriteriaRuntime {
        private static final String SCRIPT_PREFIX = "ScriptingCacheCriteriaRuntime_script";
        private Script scriptRuntime;

        public ScriptingCacheCriteriaRuntime(MetaActionMapping actionMapping) {
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptRuntime = tc.getScriptEngine().createScript(MetaScriptingCacheCriteria.this.script, "ScriptingCacheCriteriaRuntime_script_" + actionMapping.getName());
        }

        @Override
        public String createContentCacheKey(RequestContext request) {
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            TenantContext tc = ex.getTenantContext();
            ScriptEngine scriptEngine = tc.getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingCacheCriteria.REQUEST_BINDING_NAME, (Object)request);
            sc.setAttribute("user", (Object)AuthContextHolder.getAuthContext().newUserBinding());
            sc.setAttribute("auth", (Object)AuthContext.getCurrentContext());
            return (String)this.scriptRuntime.eval(sc);
        }
    }
}

