/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.fileupload.FileScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVirusScanner
implements FileScanner {
    private static final Logger logger = LoggerFactory.getLogger(DefaultVirusScanner.class);
    private String commandPath;
    private String timeout;
    private boolean errorOnTimeout;
    private List<Integer> successExitValue;
    private Long timeoutVal;

    public boolean isErrorOnTimeout() {
        return this.errorOnTimeout;
    }

    public void setErrorOnTimeout(boolean errorOnTimeout) {
        this.errorOnTimeout = errorOnTimeout;
    }

    public List<Integer> getSuccessExitValue() {
        return this.successExitValue;
    }

    public void setSuccessExitValue(List<Integer> successExitValue) {
        this.successExitValue = successExitValue;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
        this.timeoutVal = timeout != null ? Long.valueOf(timeout) : null;
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String comandPath) {
        this.commandPath = comandPath;
    }

    @Override
    public void scan(String filePath) {
        block11: {
            String command = this.commandPath.replace("${file}", filePath);
            Process proc = null;
            try {
                proc = Runtime.getRuntime().exec(command);
                if (this.timeoutVal == null) {
                    throw new NullPointerException("timeout must be specified");
                }
                boolean ret = proc.waitFor(this.timeoutVal, TimeUnit.SECONDS);
                if (ret) {
                    int exitVal = proc.exitValue();
                    if (this.successExitValue == null || this.successExitValue.size() <= 0) break block11;
                    for (Integer i : this.successExitValue) {
                        if (i != exitVal) continue;
                        return;
                    }
                    throw new RuntimeException("Scan failed. Illegal exit value:" + exitVal + ", file: " + filePath);
                }
                if (this.errorOnTimeout) {
                    throw new RuntimeException("Scan failed (timeouted). file: " + filePath);
                }
                logger.warn(WebResourceBundleUtil.resourceString("impl.web.fileupload.DefaultVirusScanHandle.timeout", new Object[0]));
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ApplicationException(WebResourceBundleUtil.resourceString("impl.web.fileupload.DefaultVirusScanHandle.failed", new Object[0]), (Throwable)e);
            }
            finally {
                if (proc != null && proc.isAlive()) {
                    proc.destroy();
                }
            }
        }
    }
}

