/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.MetaLocalizedBinary;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateRuntimeException;
import org.iplass.mtp.web.template.definition.BinaryTemplateDefinition;
import org.iplass.mtp.web.template.definition.LocalizedBinaryDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinition;

public class MetaBinaryTemplate
extends MetaTemplate {
    private static final long serialVersionUID = -1789466133481644517L;
    private String fileName;
    private byte[] binary;
    private List<MetaLocalizedBinary> localizedBinaryList = new ArrayList<MetaLocalizedBinary>();

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public List<MetaLocalizedBinary> getLocalizedBinaryList() {
        return this.localizedBinaryList;
    }

    public void setLocalizedBinaryList(List<MetaLocalizedBinary> localizedBinaryList) {
        this.localizedBinaryList = localizedBinaryList;
    }

    @Override
    public void applyConfig(TemplateDefinition definition) {
        this.fillFrom(definition);
        BinaryTemplateDefinition def = (BinaryTemplateDefinition)definition;
        this.fileName = def.getFileName();
        this.binary = def.getBinary();
        if (def.getLocalizedBinaryList() != null) {
            this.localizedBinaryList = new ArrayList<MetaLocalizedBinary>();
            for (LocalizedBinaryDefinition locale : def.getLocalizedBinaryList()) {
                MetaLocalizedBinary mlb = new MetaLocalizedBinary();
                mlb.applyConfig(locale);
                this.localizedBinaryList.add(mlb);
            }
        } else {
            this.localizedBinaryList = null;
        }
    }

    @Override
    public TemplateDefinition currentConfig() {
        BinaryTemplateDefinition definition = new BinaryTemplateDefinition();
        this.fillTo(definition);
        definition.setFileName(this.fileName);
        definition.setBinary(this.binary);
        if (this.localizedBinaryList != null) {
            for (MetaLocalizedBinary mlb : this.localizedBinaryList) {
                definition.addLocalizedBinary(mlb.currentConfig());
            }
        }
        return definition;
    }

    @Override
    public BinaryTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new BinaryTemplateRuntime();
    }

    public class BinaryTemplateRuntime
    extends MetaTemplate.TemplateRuntime {
        public BinaryTemplateRuntime() {
            super(MetaBinaryTemplate.this);
        }

        @Override
        public MetaBinaryTemplate getMetaData() {
            return MetaBinaryTemplate.this;
        }

        @Override
        public void handleContent(WebRequestStack requestContext) throws IOException, ServletException {
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            byte[] tempBinary = MetaBinaryTemplate.this.binary;
            if (MetaBinaryTemplate.this.localizedBinaryList != null) {
                for (MetaLocalizedBinary mlb : MetaBinaryTemplate.this.localizedBinaryList) {
                    if (!mlb.getLocaleName().equals(lang) || mlb.getBinaryValue() == null || mlb.getBinaryValue().length <= 0) continue;
                    tempBinary = mlb.getBinaryValue();
                }
            }
            if (requestContext.getPageContext() != null) {
                throw new TemplateRuntimeException("binary tempalte can not include from jsp... templateName:" + MetaBinaryTemplate.this.getName());
            }
            requestContext.getResponse().getOutputStream().write(tempBinary);
        }
    }
}

