/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.JspTemplateHttpServletRequest;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.definition.JspTemplateDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaJspTemplate
extends MetaTemplate {
    private static final long serialVersionUID = -2563831318096568436L;
    private static final Logger logger = LoggerFactory.getLogger(MetaJspTemplate.class);
    private String path;
    private List<MetaLocalizedString> localizedPathList = new ArrayList<MetaLocalizedString>();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<MetaLocalizedString> getLocalizedPathList() {
        return this.localizedPathList;
    }

    public void setLocalizedPathList(List<MetaLocalizedString> localizedPathList) {
        this.localizedPathList = localizedPathList;
    }

    @Override
    public JspTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new JspTemplateRuntime();
    }

    @Override
    public void applyConfig(TemplateDefinition definition) {
        this.fillFrom(definition);
        JspTemplateDefinition def = (JspTemplateDefinition)definition;
        this.path = def.getPath();
        this.localizedPathList = I18nUtil.toMeta(def.getLocalizedPathList());
    }

    @Override
    public JspTemplateDefinition currentConfig() {
        JspTemplateDefinition definition = new JspTemplateDefinition();
        this.fillTo(definition);
        definition.setPath(this.path);
        definition.setLocalizedPathList(I18nUtil.toDef(this.localizedPathList));
        return definition;
    }

    public class JspTemplateRuntime
    extends MetaTemplate.TemplateRuntime {
        public JspTemplateRuntime() {
            super(MetaJspTemplate.this);
        }

        @Override
        public MetaJspTemplate getMetaData() {
            return MetaJspTemplate.this;
        }

        @Override
        public void handleContent(WebRequestStack requestStack) throws IOException, ServletException {
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            String tempPath = MetaJspTemplate.this.getPath();
            if (MetaJspTemplate.this.localizedPathList != null) {
                for (MetaLocalizedString mls : MetaJspTemplate.this.localizedPathList) {
                    if (!mls.getLocaleName().equals(lang) || !StringUtil.isNotEmpty((String)mls.getStringValue())) continue;
                    tempPath = mls.getStringValue();
                }
            }
            if (requestStack.getPageContext() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("include(pageContext) " + tempPath + "...");
                }
                requestStack.getPageContext().include(tempPath);
            } else {
                Object req;
                if (logger.isDebugEnabled()) {
                    logger.debug("include(request) " + tempPath + "...");
                }
                if (!((req = requestStack.getRequest()) instanceof JspTemplateHttpServletRequest)) {
                    req = new JspTemplateHttpServletRequest(requestStack.getRequest(), requestStack.getRequestContext());
                }
                requestStack.getRequest().getRequestDispatcher(tempPath).include((ServletRequest)req, (ServletResponse)requestStack.getResponse());
            }
        }
    }
}

