/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.token;

import java.util.LinkedHashMap;
import java.util.Map;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUTokenStore
extends TokenStore {
    private static final long serialVersionUID = 2864948027935155294L;
    private static Logger logger = LoggerFactory.getLogger(LRUTokenStore.class);
    private final String fixedToken;
    private final LinkedHashMap<String, Object> list;

    public LRUTokenStore(final int maxSize) {
        this.list = new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = -6502264709029793582L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
                boolean ret;
                boolean bl = ret = this.size() > maxSize;
                if (ret && logger.isDebugEnabled()) {
                    logger.debug("remove(cause cache size over) transaction token:" + eldest.getKey());
                }
                return ret;
            }
        };
        this.fixedToken = StringUtil.randomToken();
    }

    @Override
    String getFixedToken() {
        return this.fixedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String createToken() {
        String token = StringUtil.randomToken();
        LRUTokenStore lRUTokenStore = this;
        synchronized (lRUTokenStore) {
            if (logger.isDebugEnabled()) {
                logger.debug("create transaction token:" + token);
            }
            this.list.put(token, Boolean.TRUE);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushBack(String token) {
        if (!token.equals(this.fixedToken)) {
            LRUTokenStore lRUTokenStore = this;
            synchronized (lRUTokenStore) {
                if (logger.isDebugEnabled()) {
                    logger.debug("push back transaction token:" + token);
                }
                this.list.put(token, Boolean.TRUE);
            }
        }
    }

    @Override
    public boolean isValidFixed(String token) {
        return this.fixedToken.equals(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String token, boolean withConsume) {
        LRUTokenStore lRUTokenStore = this;
        synchronized (lRUTokenStore) {
            if (this.fixedToken.equals(token)) {
                return true;
            }
            if (this.list.remove(token) != null) {
                if (!withConsume) {
                    this.list.put(token, Boolean.TRUE);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("consume transaction token:" + token);
                }
                return true;
            }
            return false;
        }
    }
}

