/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiParamMapping;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.command.MetaCommandFactory;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.metadata.annotation.AnnotatableMetaDataFactory;
import org.iplass.mtp.impl.metadata.annotation.AnnotateMetaDataEntry;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.MetaWebApiParamMap;
import org.iplass.mtp.impl.webapi.MetaWebApiTokenCheck;
import org.iplass.mtp.webapi.definition.CacheControlType;

public class MetaWebApiFactory
implements AnnotatableMetaDataFactory<WebApi, Object> {
    public static final String PATH_PREFIX = "/webapi/";
    private MetaCommandFactory commandFactory = new MetaCommandFactory();

    public Class<Object> getAnnotatedClass() {
        return Object.class;
    }

    public Class<WebApi> getAnnotationClass() {
        return WebApi.class;
    }

    public Map<String, AnnotateMetaDataEntry> toMetaData(Class<Object> annotatedClass) {
        WebApi webapi = annotatedClass.getAnnotation(WebApi.class);
        return this.toMetaData(webapi, annotatedClass);
    }

    Map<String, AnnotateMetaDataEntry> toMetaData(WebApi webapi, Class<Object> annotatedClass) {
        CommandClass classDef;
        HashMap<String, AnnotateMetaDataEntry> map = new HashMap<String, AnnotateMetaDataEntry>();
        MetaWebApi meta = new MetaWebApi();
        meta.setName(webapi.name());
        String path = PATH_PREFIX + webapi.name();
        if (!"##default".equals(webapi.id())) {
            meta.setId(webapi.id());
        } else {
            meta.setId(path);
        }
        meta.setName(webapi.name());
        if (webapi.command() != null) {
            MetaCommand metaCommand = this.commandFactory.toMetaCommand((CommandConfig)webapi.command(), annotatedClass).metaCommand;
            meta.setCommand(metaCommand);
        }
        if (webapi.restJson() == null) {
            meta.setRestJsonParameterName(null);
            meta.setRestJsonParameterType(Void.TYPE);
        } else {
            meta.setRestJsonParameterName(webapi.restJson().parameterName());
            meta.setRestJsonParameterType(webapi.restJson().parameterType());
        }
        if (webapi.restXml() == null) {
            meta.setRestXmlParameterName(null);
        } else {
            meta.setRestXmlParameterName(webapi.restXml().parameterName());
        }
        if (!"##default".equals(webapi.displayName())) {
            meta.setDisplayName(webapi.displayName());
        } else {
            classDef = annotatedClass.getAnnotation(CommandClass.class);
            if (classDef != null && !"##default".equals(classDef.displayName())) {
                meta.setDisplayName(classDef.displayName());
            }
        }
        if (!"##default".equals(webapi.description())) {
            meta.setDescription(webapi.description());
        } else {
            classDef = annotatedClass.getAnnotation(CommandClass.class);
            if (classDef != null && !"##default".equals(classDef.description())) {
                meta.setDescription(classDef.description());
            }
        }
        if (webapi.cacheControlType() != null) {
            switch (webapi.cacheControlType()) {
                case CACHE: {
                    meta.setCacheControlType(CacheControlType.CACHE);
                    break;
                }
                case NO_CACHE: {
                    meta.setCacheControlType(CacheControlType.NO_CACHE);
                    break;
                }
            }
        }
        meta.setCacheControlMaxAge(webapi.cacheControlMaxAge());
        meta.setAccepts(webapi.accepts());
        meta.setMethods(webapi.methods());
        if (webapi.allowRequestContentTypes().length > 0) {
            String[] allowRequestContentTypes = new String[webapi.allowRequestContentTypes().length];
            System.arraycopy(webapi.allowRequestContentTypes(), 0, allowRequestContentTypes, 0, allowRequestContentTypes.length);
            meta.setAllowRequestContentTypes(allowRequestContentTypes);
        }
        if (webapi.maxRequestBodySize() != Long.MIN_VALUE) {
            meta.setMaxRequestBodySize(webapi.maxRequestBodySize());
        }
        if (webapi.maxFileSize() != Long.MIN_VALUE) {
            meta.setMaxFileSize(webapi.maxFileSize());
        }
        meta.setResults(webapi.results());
        meta.setState(webapi.state());
        meta.setSupportBearerToken(webapi.supportBearerToken());
        if (webapi.oauthScopes() != null && webapi.oauthScopes().length > 0) {
            meta.setOauthScopes(webapi.oauthScopes());
        }
        meta.setPrivilaged(webapi.privilaged());
        meta.setPublicWebApi(webapi.publicWebApi());
        meta.setCheckXRequestedWithHeader(webapi.checkXRequestedWithHeader());
        meta.setResponseType(webapi.responseType());
        if (webapi.paramMapping().length > 0) {
            MetaWebApiParamMap[] paramMap = new MetaWebApiParamMap[webapi.paramMapping().length];
            for (int i = 0; i < paramMap.length; ++i) {
                WebApiParamMapping anoParamMap = webapi.paramMapping()[i];
                paramMap[i] = new MetaWebApiParamMap(anoParamMap.name(), anoParamMap.mapFrom());
                if ("##default".equals(anoParamMap.condition())) continue;
                paramMap[i].setCondition(anoParamMap.condition());
            }
            meta.setWebApiParamMap(paramMap);
        }
        if (webapi.tokenCheck().executeCheck()) {
            MetaWebApiTokenCheck tokenCheck = new MetaWebApiTokenCheck();
            tokenCheck.setConsume(webapi.tokenCheck().consume());
            tokenCheck.setExceptionRollback(webapi.tokenCheck().exceptionRollback());
            tokenCheck.setUseFixedToken(webapi.tokenCheck().useFixedToken());
            meta.setTokenCheck(tokenCheck);
        }
        meta.setSynchronizeOnSession(webapi.synchronizeOnSession());
        meta.setAccessControlAllowOrigin(webapi.accessControlAllowOrign());
        meta.setAccessControlAllowCredentials(webapi.accessControlAllowCredentials());
        meta.setNeedTrustedAuthenticate(webapi.needTrustedAuthenticate());
        map.put(path, new AnnotateMetaDataEntry((RootMetaData)meta, webapi.overwritable(), webapi.permissionSharable()));
        return map;
    }
}

