/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import groovy.lang.MissingPropertyException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;

class WebApiGroovyTemplateBinding
extends GroovyTemplateBinding {
    private RequestContext request;

    WebApiGroovyTemplateBinding(Writer out, RequestContext request) {
        super(out);
        this.request = request;
        if (request != null) {
            this.setVariable("request", request);
            this.setVariable("session", new LazySessionContext(request));
        }
    }

    public Object getVariable(String name) {
        try {
            return super.getVariable(name);
        }
        catch (MissingPropertyException e) {
            if (this.request == null) {
                throw e;
            }
            Object val = this.request.getAttribute(name);
            if (val == null && this.request.getSession(false) != null) {
                val = this.request.getSession(false).getAttribute(name);
            }
            if (val == null) {
                throw e;
            }
            return val;
        }
    }

    public boolean hasVariable(String name) {
        boolean ret = super.hasVariable(name);
        if (this.request == null) {
            return ret;
        }
        if (!ret) {
            boolean bl = ret = this.request.getAttribute(name) != null;
        }
        if (!ret && this.request.getSession(false) != null) {
            ret = this.request.getSession(false).getAttribute(name) != null;
        }
        return ret;
    }

    public Map getVariables() {
        return super.getVariables();
    }

    private static class LazySessionContext
    implements SessionContext {
        private final RequestContext req;
        private SessionContext sess;

        private LazySessionContext(RequestContext req) {
            this.req = req;
        }

        private void initSess() {
            if (this.sess == null) {
                this.sess = this.req.getSession();
            }
        }

        public Object getAttribute(String name) {
            this.initSess();
            return this.sess.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.initSess();
            this.sess.setAttribute(name, value);
        }

        public Iterator<String> getAttributeNames() {
            this.initSess();
            return this.sess.getAttributeNames();
        }

        public void removeAttribute(String name) {
            this.initSess();
            this.sess.removeAttribute(name);
        }

        public BinaryReference loadFromTemporary(long lobId) {
            this.initSess();
            return this.sess.loadFromTemporary(lobId);
        }
    }
}

