/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.entity.csv.EntitySearchCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.iplass.mtp.impl.entity.csv.QueryCsvWriter;
import org.iplass.mtp.impl.entity.csv.QueryWriteOption;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.webapi.WebApiResponse;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.impl.webapi.command.entity.QueryJsonWriter;
import org.iplass.mtp.impl.webapi.command.entity.QueryXmlWriter;
import org.iplass.mtp.impl.webapi.jackson.WebApiObjectMapperService;
import org.iplass.mtp.impl.webapi.jaxb.WebApiJaxbService;
import org.iplass.mtp.impl.xml.jaxb.DateXmlAdapter;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.entity.SearchResultLimitExceededException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@WebApi(name="mtp/entity/GET", accepts={RequestType.REST_FORM}, methods={MethodType.GET}, results={"list", "count", "entity", "csv", "json", "xml"}, responseType="application/json, application/xml, text/csv;charset=utf-8", overwritable=false)
@CommandClass(name="mtp/entity/GetEntityCommand", displayName="Entity Query/Load Web API", overwritable=false)
public final class GetEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_TABLE_MODE = "tabular";
    public static final String PARAM_COUNT_TOTAL = "countTotal";
    public static final String PARAM_FILTER = "filter";
    public static final String PARAM_WITH_MAPPED_BY_REFERENCE = "withMappedByReference";
    public static final String RESULT_ENTITY_LIST = "list";
    public static final String RESULT_COUNT = "count";
    public static final String RESULT_ENTITY = "entity";
    public static final String RESULT_CSV = "csv";
    public static final String RESULT_JSON = "json";
    public static final String RESULT_XML = "xml";
    private final JAXBContext context = ((WebApiJaxbService)ServiceRegistry.getRegistry().getService(WebApiJaxbService.class)).getJAXBContext();
    private final Map<String, String> nameSpaceMap = new HashMap<String, String>();
    private final JsonFactory jsonFactory = new JsonFactory();
    private final ObjectMapper mapper = ((WebApiObjectMapperService)ServiceRegistry.getRegistry().getService(WebApiObjectMapperService.class)).getObjectMapper().copy();

    public GetEntityCommand() {
        Document doc;
        this.mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        this.mapper.disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE});
        WebApiResponse webApiResponse = new WebApiResponse();
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.marshal((Object)webApiResponse, (Node)doc);
        }
        catch (JAXBException | ParserConfigurationException e) {
            throw new SystemException(e);
        }
        Element element = doc.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String[] str = namedNodeMap.item(i).getNodeName().split(":");
            this.nameSpaceMap.put(str[1], namedNodeMap.item(i).getNodeValue());
        }
    }

    private void query(RequestContext request) {
        String eql = request.getParam(PARAM_QUERY);
        if (eql == null) {
            throw new NullPointerException("query must specify");
        }
        Query query = Query.newQuery((String)eql);
        this.queryImpl(query, request, true, this.resType(request), false);
    }

    private void list(String entityDef, RequestContext request) {
        ResType resType = this.resType(request);
        boolean withMappedBy = this.withMappedByReference(request, resType == ResType.CSV ? this.entityWebApiService.isCsvListWithMappedByReference() : this.entityWebApiService.isListWithMappedByReference());
        Query query = new Query().selectAll(entityDef, false, true, false, withMappedBy);
        String filter = request.getParam(PARAM_FILTER);
        if (filter != null) {
            query.where(filter);
        }
        this.queryImpl(query, request, false, resType, withMappedBy);
    }

    private void queryImpl(Query query, RequestContext request, boolean byQuery, ResType resType, boolean withMappedBy) {
        this.checkPermission(query.getFrom().getEntityName(), def -> def.getMetaData().isQuery());
        SearchOption option = new SearchOption();
        option.setReturnStructuredEntity(true);
        if (resType == ResType.CSV) {
            if (byQuery) {
                this.queryCsv(query, request);
            } else {
                this.listCsv(query, request, withMappedBy);
            }
        } else {
            boolean tabular = (Boolean)request.getParam(PARAM_TABLE_MODE, Boolean.class, (Object)false);
            boolean countTotal = (Boolean)request.getParam(PARAM_COUNT_TOTAL, Boolean.class, (Object)false);
            if (tabular) {
                if (resType == ResType.JSON) {
                    this.queryJson(query, request, countTotal);
                } else if (resType == ResType.XML) {
                    this.queryXml(query, request, countTotal);
                }
            } else {
                this.queryOther(query, request, countTotal);
            }
        }
    }

    private void queryOther(Query query, RequestContext request, boolean countTotal) {
        boolean noLimit;
        SearchOption option = new SearchOption();
        option.setReturnStructuredEntity(true);
        boolean bl = noLimit = query.getLimit() == null;
        if (countTotal || this.entityWebApiService.isThrowSearchResultLimitExceededException() && noLimit) {
            option.setCountTotal(true);
        }
        if (noLimit) {
            query.limit(this.entityWebApiService.getMaxLimit());
        }
        if (query.getLimit().getLimit() > this.entityWebApiService.getMaxLimit()) {
            throw new IllegalArgumentException("Can not specify limit more than " + this.entityWebApiService.getMaxLimit());
        }
        SearchResult res = this.em.searchEntity(query, option);
        if (this.entityWebApiService.isThrowSearchResultLimitExceededException() && noLimit && res.getTotalCount() > this.entityWebApiService.getMaxLimit()) {
            throw new SearchResultLimitExceededException(WebResourceBundleUtil.resourceString("impl.webapi.command.entity.GetEntityCommand.limitExceeded", new Object[0]));
        }
        request.setAttribute(RESULT_ENTITY_LIST, (Object)res.getList());
        if (countTotal) {
            request.setAttribute(RESULT_COUNT, (Object)res.getTotalCount());
        }
    }

    private void queryCsv(Query query, RequestContext request) {
        StreamingOutput stream = out -> {
            QueryWriteOption option = new QueryWriteOption();
            option.setDateFormat(this.entityWebApiService.getCsvDateFormat());
            option.setDatetimeSecFormat(this.entityWebApiService.getCsvDateTimeFormat());
            option.setTimeSecFormat(this.entityWebApiService.getCsvTimeFormat());
            try (QueryCsvWriter writer = new QueryCsvWriter(out, query, option);){
                writer.write();
            }
        };
        request.setAttribute(RESULT_CSV, (Object)stream);
    }

    private void listCsv(Query query, RequestContext request, boolean withMappedBy) {
        CsvUploadService csvUploadService = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
        StreamingOutput stream = out -> {
            EntityWriteOption option = new EntityWriteOption().where(query.getWhere()).orderBy(query.getOrderBy()).dateFormat(this.entityWebApiService.getCsvDateFormat()).datetimeSecFormat(this.entityWebApiService.getCsvDateTimeFormat()).timeSecFormat(this.entityWebApiService.getCsvTimeFormat()).withMappedByReference(withMappedBy).mustOrderByWithLimit(csvUploadService.isMustOrderByWithLimit());
            try (EntitySearchCsvWriter writer = new EntitySearchCsvWriter(out, query.getFrom().getEntityName(), option);){
                writer.write();
            }
        };
        request.setAttribute(RESULT_CSV, (Object)stream);
    }

    private void queryJson(Query query, RequestContext request, boolean countTotal) {
        StreamingOutput stream = out -> {
            try (QueryJsonWriter writer = new QueryJsonWriter(out, query, countTotal, this.mapper, this.jsonFactory);){
                writer.write();
            }
        };
        request.setAttribute(RESULT_JSON, (Object)stream);
    }

    private void queryXml(Query query, RequestContext request, boolean countTotal) {
        StreamingOutput stream = out -> {
            try (QueryXmlWriter writer = new QueryXmlWriter(out, query, countTotal, this.context, this.nameSpaceMap, new DateXmlAdapter());){
                writer.write();
            }
        };
        request.setAttribute(RESULT_XML, (Object)stream);
    }

    private ResType resType(RequestContext request) {
        String accept = ((HttpServletRequest)request.getAttribute("servletRequest")).getHeader("Accept");
        if (accept != null) {
            if (accept.startsWith("application/json")) {
                return ResType.JSON;
            }
            if (accept.startsWith("text/csv")) {
                return ResType.CSV;
            }
            if (accept.startsWith("application/xml")) {
                return ResType.XML;
            }
        }
        return ResType.OTHER;
    }

    private void load(String entityDef, String oid, String ver, RequestContext request) {
        Entity e;
        this.checkPermission(entityDef, def -> def.getMetaData().isLoad());
        Long version = null;
        if (ver != null) {
            version = Long.parseLong(ver);
        }
        if ((e = this.em.load(oid, version, entityDef, new LoadOption(true, this.withMappedByReference(request, this.entityWebApiService.isLoadWithMappedByReference())))) != null) {
            request.setAttribute(RESULT_ENTITY, (Object)e);
        }
    }

    private boolean withMappedByReference(RequestContext request, boolean defaultVale) {
        Boolean wmbr = request.getParamAsBoolean(PARAM_WITH_MAPPED_BY_REFERENCE);
        if (wmbr == null) {
            return defaultVale;
        }
        return wmbr;
    }

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length == 0) {
            this.query(request);
        } else {
            switch (subPath.length) {
                case 1: {
                    this.list(subPath[0], request);
                    break;
                }
                case 2: {
                    this.load(subPath[0], subPath[1], null, request);
                    break;
                }
                case 3: {
                    this.load(subPath[0], subPath[1], subPath[2], request);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal path parameter:" + subPath);
                }
            }
        }
        return "SUCCESS";
    }

    private static enum ResType {
        CSV,
        JSON,
        XML,
        OTHER;

    }
}

