/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.iris_events.annotations.Scope;
import org.iris_events.asyncapi.runtime.scanner.model.ClientDefinitions;

public class ClientDefinitionParser {
    public ClientDefinitions parse(JsonNode asyncapiRootNode) {
        EnumSet<Scope> scopes = EnumSet.of(Scope.FRONTEND, Scope.USER, Scope.SESSION, Scope.BROADCAST);
        Map<String, JsonNode> feScopeChannels = this.getChannelsInScope(asyncapiRootNode.get("channels"), scopes);
        Map<String, JsonNode> schemasNodes = this.getTopLevelSchemaNodes(asyncapiRootNode.get("components").get("schemas"), feScopeChannels);
        schemasNodes.putAll(this.getSchemaNodes(this.getReferencedSchemaNodes(schemasNodes, asyncapiRootNode), asyncapiRootNode));
        return new ClientDefinitions(asyncapiRootNode.findValue("info").findValue("title").asText(), feScopeChannels, schemasNodes);
    }

    private Map<String, JsonNode> getSchemaNodes(Set<String> referencedSchemaNodes, JsonNode rootNode) {
        JsonNode schemas = rootNode.findPath("components").findPath("schemas");
        return referencedSchemaNodes.stream().collect(Collectors.toMap(s -> s, arg_0 -> ((JsonNode)schemas).findPath(arg_0)));
    }

    private Set<String> getReferencedSchemaNodes(Map<String, JsonNode> rootSchemaNodes, JsonNode rootNode) {
        Set<String> refsOfInterest = rootSchemaNodes.values().stream().filter(schemaNode -> schemaNode != null && !schemaNode.findPath("properties").isEmpty() && !schemaNode.findPath("properties").findValues("$ref").isEmpty()).map(nodeOfInterest -> nodeOfInterest.findValues("$ref")).flatMap(Collection::stream).map(jsonNode -> jsonNode.asText().replace("#/components/schemas/", "")).collect(Collectors.toSet());
        JsonNode componentSchemas = rootNode.findPath("components").findPath("schemas");
        Map<String, JsonNode> newRootSchemaNodes = refsOfInterest.stream().map(ref -> ref.replace("#/components/schemas/", "")).collect(Collectors.toMap(s -> s, arg_0 -> ((JsonNode)componentSchemas).findPath(arg_0)));
        if (newRootSchemaNodes.isEmpty()) {
            return new HashSet<String>();
        }
        refsOfInterest.addAll(this.getReferencedSchemaNodes(newRootSchemaNodes, rootNode));
        return refsOfInterest;
    }

    private Map<String, JsonNode> getTopLevelSchemaNodes(JsonNode schemasNode, Map<String, JsonNode> feScopeChannels) {
        return feScopeChannels.values().stream().map(scopeChannelNode -> this.extractRefValue((JsonNode)scopeChannelNode).replace("#/components/schemas/", "")).collect(Collectors.toMap(s -> s, arg_0 -> ((JsonNode)schemasNode).get(arg_0), (s1, s2) -> s1));
    }

    private String extractRefValue(JsonNode scopeChannelNode) {
        JsonNode operationNode = Optional.ofNullable(scopeChannelNode.get("publish")).orElse(scopeChannelNode.get("subscribe"));
        return operationNode.get("message").get("payload").get("$ref").asText();
    }

    private Stream<Map.Entry<String, JsonNode>> fieldsToStream(Iterator<Map.Entry<String, JsonNode>> fields) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(fields, 16), false);
    }

    private Map<String, JsonNode> getChannelsInScope(JsonNode channelsNode, EnumSet<Scope> scopes) {
        return this.fieldsToStream(channelsNode.fields()).filter(channelNode -> {
            JsonNode operationNode = Optional.ofNullable(((JsonNode)channelNode.getValue()).get("publish")).orElse(((JsonNode)channelNode.getValue()).get("subscribe"));
            String scopeValue = operationNode.get("message").get("headers").get("properties").get("x-scope").get("value").asText();
            return scopes.contains(Scope.valueOf((String)scopeValue.toUpperCase()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

