/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Schema;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SchemaImpl;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.iris_events.annotations.Scope;
import org.iris_events.asyncapi.runtime.scanner.model.ChannelInfo;
import org.iris_events.asyncapi.spec.annotations.enums.SchemaType;
import org.jboss.jandex.Type;

public class HeaderSchemaBuilder {
    private static final String ROLES_ALLOWED_DESCRIPTION = "Allowed roles for this message. Default is empty";
    private static final String SCOPE_DESCRIPTION = "Message scope. Default is INTERNAL";
    private static final String DEAD_LETTER_DESCRIPTION = "Dead letter queue definition. Default is dead-letter";
    private static final String TTL_DESCRIPTION = "TTL of the message. If set to -1 (default) will use brokers default.";
    private static final String RPC_RESPONSE_DESCRIPTION = "RPC response type property.";
    private final ObjectMapper objectMapper;

    public HeaderSchemaBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public AsyncApi26SchemaImpl buildHeaders(ChannelInfo channelInfo, Map<String, Scope> messageScopes) {
        AsyncApi26SchemaImpl headersSchema = new AsyncApi26SchemaImpl();
        headersSchema.setType(SchemaType.OBJECT.toString());
        headersSchema.addProperty("x-scope", (Schema)this.buildScopeSchema(channelInfo, messageScopes));
        headersSchema.addProperty("x-ttl", (Schema)this.buildTtlSchema(channelInfo));
        headersSchema.addProperty("x-roles-allowed", (Schema)this.buildRolesAllowedSchema(channelInfo));
        headersSchema.addProperty("x-dead-letter", (Schema)this.buildDeadLetterSchema(channelInfo));
        Optional.ofNullable(this.buildRpcResponseTypeSchema(channelInfo)).ifPresent(rpcResponseTypeSchema -> headersSchema.addProperty("x-rpc-response-type", (Schema)rpcResponseTypeSchema));
        return headersSchema;
    }

    private AsyncApi26Schema buildRolesAllowedSchema(ChannelInfo channelInfo) {
        Set<String> rolesAllowed = channelInfo.getRolesAllowed();
        AsyncApi26SchemaImpl rolesAllowedSchema = new AsyncApi26SchemaImpl();
        rolesAllowedSchema.setType(SchemaType.ARRAY.toString());
        rolesAllowedSchema.setDescription(ROLES_ALLOWED_DESCRIPTION);
        ArrayNode extensionSchemas = this.objectMapper.createArrayNode();
        rolesAllowed.forEach(arg_0 -> ((ArrayNode)extensionSchemas).add(arg_0));
        rolesAllowedSchema.addExtension("value", (JsonNode)extensionSchemas);
        return rolesAllowedSchema;
    }

    private AsyncApi26Schema buildScopeSchema(ChannelInfo channelInfo, Map<String, Scope> messageScopes) {
        Scope scope = this.getScope(messageScopes, channelInfo.getEventKey());
        AsyncApi26SchemaImpl scopeSchema = new AsyncApi26SchemaImpl();
        scopeSchema.setType(SchemaType.STRING.toString());
        scopeSchema.setDescription(SCOPE_DESCRIPTION);
        scopeSchema.addExtension("value", (JsonNode)TextNode.valueOf((String)scope.name()));
        return scopeSchema;
    }

    private AsyncApi26Schema buildDeadLetterSchema(ChannelInfo channelInfo) {
        String deadLetterQueue = channelInfo.getDeadLetterQueue();
        AsyncApi26SchemaImpl deadLetterSchema = new AsyncApi26SchemaImpl();
        deadLetterSchema.setType(SchemaType.STRING.toString());
        deadLetterSchema.setDescription(DEAD_LETTER_DESCRIPTION);
        deadLetterSchema.addExtension("value", (JsonNode)TextNode.valueOf((String)deadLetterQueue));
        return deadLetterSchema;
    }

    private AsyncApi26Schema buildTtlSchema(ChannelInfo channelInfo) {
        Integer ttl = channelInfo.getTtl();
        AsyncApi26SchemaImpl ttlSchema = new AsyncApi26SchemaImpl();
        ttlSchema.setType(SchemaType.INTEGER.toString());
        ttlSchema.setDescription(TTL_DESCRIPTION);
        ttlSchema.addExtension("value", (JsonNode)IntNode.valueOf((int)ttl));
        return ttlSchema;
    }

    private AsyncApi26Schema buildRpcResponseTypeSchema(ChannelInfo channelInfo) {
        Type rpcResponseType = channelInfo.getRpcResponseType();
        if (rpcResponseType == null) {
            return null;
        }
        String rpcResponseTypeEventName = rpcResponseType.asClassType().name().toString();
        AsyncApi26SchemaImpl rpcResponseSchema = new AsyncApi26SchemaImpl();
        rpcResponseSchema.setType(SchemaType.STRING.toString());
        rpcResponseSchema.setDescription(RPC_RESPONSE_DESCRIPTION);
        rpcResponseSchema.addExtension("value", (JsonNode)TextNode.valueOf((String)rpcResponseTypeEventName));
        return rpcResponseSchema;
    }

    private Scope getScope(Map<String, Scope> messageScopes, String messageKey) {
        return messageScopes.get(messageKey);
    }
}

