/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.api;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.iris_events.asyncapi.api.AsyncApiConfig;
import org.iris_events.asyncapi.api.util.ConfigUtil;

public class AsyncApiConfigImpl
implements AsyncApiConfig {
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Set<String> scanPackages;
    private Set<String> scanClasses;
    private Set<String> scanExcludePackages;
    private Set<String> scanExcludeClasses;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;
    private Boolean schemaReferencesEnable;
    private String customSchemaRegistryClass;
    private Set<String> excludeFromSchemas;
    private String projectVersion;

    public AsyncApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public String modelReader() {
        if (this.modelReader != null) {
            return this.modelReader;
        }
        this.modelReader = this.getConfig().getOptionalValue("mp.asyncapi.model.reader", String.class).orElse(null);
        return this.modelReader;
    }

    @Override
    public String filter() {
        if (this.filter != null) {
            return this.filter;
        }
        this.filter = this.getConfig().getOptionalValue("mp.asyncapi.filter", String.class).orElse(null);
        return this.filter;
    }

    @Override
    public boolean scanDisable() {
        if (this.scanDisable != null) {
            return this.scanDisable;
        }
        this.scanDisable = this.getConfig().getOptionalValue("mp.asyncapi.scan.disable", Boolean.class).orElse(false);
        return this.scanDisable;
    }

    @Override
    public Set<String> scanPackages() {
        if (this.scanPackages != null) {
            return this.scanPackages;
        }
        String packages = this.getConfig().getOptionalValue("mp.asyncapi.scan.packages", String.class).orElse(null);
        this.scanPackages = ConfigUtil.asCsvSet(packages);
        return this.scanPackages;
    }

    @Override
    public Pattern scanPackagesPattern() {
        return ConfigUtil.patternFromSet(this.scanPackages());
    }

    @Override
    public Set<String> scanClasses() {
        if (this.scanClasses != null) {
            return this.scanClasses;
        }
        String classes = this.getConfig().getOptionalValue("mp.asyncapi.scan.classes", String.class).orElse(null);
        this.scanClasses = ConfigUtil.asCsvSet(classes);
        return this.scanClasses;
    }

    @Override
    public Pattern scanClassesPattern() {
        return ConfigUtil.patternFromSet(this.scanClasses());
    }

    @Override
    public Set<String> scanExcludePackages() {
        if (this.scanExcludePackages != null) {
            return this.scanExcludePackages;
        }
        String packages = this.getConfig().getOptionalValue("mp.asyncapi.scan.exclude.packages", String.class).orElse(null);
        this.scanExcludePackages = ConfigUtil.asCsvSet(packages);
        return this.scanExcludePackages;
    }

    @Override
    public Pattern scanExcludePackagesPattern() {
        return ConfigUtil.patternFromSet(this.scanExcludePackages());
    }

    @Override
    public Set<String> scanExcludeClasses() {
        if (this.scanExcludeClasses != null) {
            return this.scanExcludeClasses;
        }
        String classes = this.getConfig().getOptionalValue("mp.asyncapi.scan.exclude.classes", String.class).orElse(null);
        this.scanExcludeClasses = ConfigUtil.asCsvSet(classes);
        return this.scanExcludeClasses;
    }

    @Override
    public Pattern scanExcludeClassesPattern() {
        return ConfigUtil.patternFromSet(this.scanExcludeClasses());
    }

    @Override
    public Set<String> servers() {
        if (this.servers != null) {
            return this.servers;
        }
        String theServers = this.getConfig().getOptionalValue("mp.asyncapi.servers", String.class).orElse(null);
        this.servers = ConfigUtil.asCsvSet(theServers);
        return this.servers;
    }

    @Override
    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable != null) {
            return this.scanDependenciesDisable;
        }
        this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.asyncapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false);
        return this.scanDependenciesDisable;
    }

    @Override
    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars != null) {
            return this.scanDependenciesJars;
        }
        String classes = this.getConfig().getOptionalValue("mp.asyncapi.extensions.scan-dependencies.jars", String.class).orElse(null);
        this.scanDependenciesJars = ConfigUtil.asCsvSet(classes);
        return this.scanDependenciesJars;
    }

    @Override
    public boolean schemaReferencesEnable() {
        if (this.schemaReferencesEnable != null) {
            return this.schemaReferencesEnable;
        }
        this.schemaReferencesEnable = this.getConfig().getOptionalValue("mp.asyncapi.extensions.schema-references.enable", Boolean.class).orElse(false);
        return this.schemaReferencesEnable;
    }

    @Override
    public String customSchemaRegistryClass() {
        if (this.customSchemaRegistryClass != null) {
            return this.customSchemaRegistryClass;
        }
        this.customSchemaRegistryClass = this.getConfig().getOptionalValue("mp.asyncapi.extensions.custom-schema-registry.class", String.class).orElse(null);
        return this.customSchemaRegistryClass;
    }

    @Override
    public Set<String> excludeFromSchemas() {
        if (this.excludeFromSchemas != null) {
            return this.excludeFromSchemas;
        }
        String packages = this.getConfig().getOptionalValue("mp.asyncapi.exclude-from-schemas", String.class).orElse(null);
        this.excludeFromSchemas = ConfigUtil.asCsvSet(packages);
        return this.excludeFromSchemas;
    }

    @Override
    public String projectVersion() {
        if (this.projectVersion != null) {
            return this.projectVersion;
        }
        this.projectVersion = this.getConfig().getOptionalValue("mp.asyncapi.project.version", String.class).orElse(null);
        return this.projectVersion;
    }
}

