/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.scanner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Document;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26InfoImpl;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.iris_events.annotations.CachedMessage;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Message;
import org.iris_events.annotations.MessageHandler;
import org.iris_events.annotations.Scope;
import org.iris_events.annotations.SnapshotMessageHandler;
import org.iris_events.asyncapi.api.AsyncApiConfig;
import org.iris_events.asyncapi.parsers.BindingKeysParser;
import org.iris_events.asyncapi.parsers.CacheableTtlParser;
import org.iris_events.asyncapi.parsers.DeadLetterQueueParser;
import org.iris_events.asyncapi.parsers.ExchangeParser;
import org.iris_events.asyncapi.parsers.ExchangeTtlParser;
import org.iris_events.asyncapi.parsers.ExchangeTypeParser;
import org.iris_events.asyncapi.parsers.MessageScopeParser;
import org.iris_events.asyncapi.parsers.PersistentParser;
import org.iris_events.asyncapi.parsers.QueueAutoDeleteParser;
import org.iris_events.asyncapi.parsers.QueueDurableParser;
import org.iris_events.asyncapi.parsers.ResourceTypeParser;
import org.iris_events.asyncapi.parsers.ResponseParser;
import org.iris_events.asyncapi.parsers.RolesAllowedParser;
import org.iris_events.asyncapi.parsers.RoutingKeyParser;
import org.iris_events.asyncapi.parsers.RpcResponseClassParser;
import org.iris_events.asyncapi.runtime.generator.CustomDefinitionProvider;
import org.iris_events.asyncapi.runtime.io.components.ComponentReader;
import org.iris_events.asyncapi.runtime.scanner.AnnotationScannerContext;
import org.iris_events.asyncapi.runtime.scanner.BaseAnnotationScanner;
import org.iris_events.asyncapi.runtime.scanner.FilteredIndexView;
import org.iris_events.asyncapi.runtime.scanner.model.ChannelInfo;
import org.iris_events.asyncapi.runtime.scanner.model.GidAsyncApi26Schema;
import org.iris_events.asyncapi.runtime.scanner.model.GidOpenApiModule;
import org.iris_events.asyncapi.runtime.scanner.model.GidOpenApiOption;
import org.iris_events.asyncapi.runtime.scanner.model.JsonSchemaInfo;
import org.iris_events.asyncapi.runtime.scanner.validator.MessageAnnotationValidator;
import org.iris_events.asyncapi.runtime.util.ChannelInfoGenerator;
import org.iris_events.asyncapi.runtime.util.SchemeIdGenerator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisAnnotationScanner
extends BaseAnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(IrisAnnotationScanner.class);
    private final SchemaGenerator schemaGenerator;
    private final String projectName;
    private final String projectGroupId;
    private final String projectVersion;
    public static final DotName DOT_NAME_MESSAGE = DotName.createSimple((String)Message.class.getName());
    public static final DotName DOT_NAME_CACHED_MESSAGE = DotName.createSimple((String)CachedMessage.class.getName());
    public static final DotName DOT_NAME_MESSAGE_HANDLER = DotName.createSimple((String)MessageHandler.class.getName());
    public static final DotName DOT_NAME_SNAPSHOT_MESSAGE_HANDLER = DotName.createSimple((String)SnapshotMessageHandler.class.getName());

    public IrisAnnotationScanner(AsyncApiConfig config, IndexView index, String projectName, String projectGroupId, String projectVersion, ObjectMapper objectMapper) {
        super(config, index, objectMapper);
        this.schemaGenerator = this.initSchemaGenerator(config);
        this.projectName = projectName;
        this.projectGroupId = projectGroupId;
        this.projectVersion = projectVersion;
    }

    public IrisAnnotationScanner(AsyncApiConfig config, IndexView index, ClassLoader classLoader, String projectName, String projectGroupId, String projectVersion, ObjectMapper objectMapper) {
        super(config, index, classLoader, objectMapper);
        this.schemaGenerator = this.initSchemaGenerator(config);
        this.projectName = projectName;
        this.projectGroupId = projectGroupId;
        this.projectVersion = projectVersion;
    }

    @Override
    public AsyncApi26Document scan() {
        LOG.debug("Scanning deployment for Async Annotations.");
        try {
            return this.scanIrisAnnotations();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not create AaiDocument", (Throwable)e);
            throw new RuntimeException("Could not create AaiDocument", e);
        }
    }

    private AsyncApi26Document scanIrisAnnotations() throws ClassNotFoundException {
        AsyncApi26Document asyncApi = this.annotationScannerContext.getAsyncApi();
        this.setDocumentInfo(asyncApi);
        List<AnnotationInstance> messageAnnotations = this.getMessageAnnotations(this.annotationScannerContext.getIndex()).collect(Collectors.toList());
        LOG.debug(String.format("Got %s message annotations", messageAnnotations.size()));
        MessageAnnotationValidator validator = new MessageAnnotationValidator();
        validator.validateReservedNames(messageAnnotations, this.projectName, this.projectGroupId);
        List<AnnotationInstance> handlerAnnotations = this.getHandlerAnnotations(this.annotationScannerContext.getIndex(), List.of(DOT_NAME_MESSAGE_HANDLER, DOT_NAME_SNAPSHOT_MESSAGE_HANDLER));
        List<AnnotationInstance> consumedMessageAnnotations = this.processMessageHandlerAnnotations(handlerAnnotations, this.annotationScannerContext, asyncApi);
        LOG.debug(String.format("Got %s consumed message annotations", consumedMessageAnnotations.size()));
        this.processProducedMessages(this.annotationScannerContext, asyncApi, messageAnnotations, consumedMessageAnnotations);
        this.processContextDefinitionReferencedSchemas(this.annotationScannerContext, asyncApi);
        return asyncApi;
    }

    private List<AnnotationInstance> getHandlerAnnotations(IndexView index, List<DotName> handlerDotNames) {
        return handlerDotNames.stream().map(arg_0 -> ((IndexView)index).getAnnotations(arg_0)).flatMap(Collection::stream).filter(this::annotatedMethods).toList();
    }

    private Stream<AnnotationInstance> getMessageAnnotations(IndexView index) {
        DotName annotationName = DotName.createSimple((String)Message.class.getName());
        return index.getAnnotations(annotationName).stream().filter(this::annotatedClasses);
    }

    private void processProducedMessages(AnnotationScannerContext context, AsyncApi26Document asyncApi, List<AnnotationInstance> messageAnnotations, List<AnnotationInstance> consumedMessageAnnotations) throws ClassNotFoundException {
        FilteredIndexView index = context.getIndex();
        messageAnnotations.removeAll(consumedMessageAnnotations);
        ArrayList<ChannelInfo> channelInfos = new ArrayList<ChannelInfo>();
        HashMap<String, JsonSchemaInfo> producedMessages = new HashMap<String, JsonSchemaInfo>();
        HashMap<String, Scope> messageScopes = new HashMap<String, Scope>();
        for (AnnotationInstance anno : messageAnnotations) {
            ClassInfo classInfo = anno.target().asClass();
            String classSimpleName = classInfo.simpleName();
            messageScopes.put(classSimpleName, MessageScopeParser.getFromAnnotationInstance(anno, index));
            producedMessages.put(classSimpleName, this.generateProducedMessageSchemaInfo(classInfo, index));
            String routingKey = RoutingKeyParser.getFromAnnotationInstance(anno);
            ExchangeType exchangeType = ExchangeTypeParser.getFromAnnotationInstance(anno, index);
            String exchange = ExchangeParser.getFromAnnotationInstance(anno);
            Set<String> rolesAllowed = RolesAllowedParser.getFromAnnotationInstance(anno, index);
            String deadLetterQueue = DeadLetterQueueParser.getFromAnnotationInstance(anno, index);
            Integer ttl = ExchangeTtlParser.getFromAnnotationInstance(anno, index);
            boolean persistent = PersistentParser.getFromAnnotationInstance(anno, index);
            channelInfos.add(ChannelInfoGenerator.generateSubscribeChannelInfo(exchange, routingKey, classSimpleName, exchangeType, rolesAllowed, deadLetterQueue, ttl, persistent));
        }
        this.insertComponentSchemas(context, producedMessages, asyncApi);
        this.createChannels(channelInfos, messageScopes, asyncApi);
    }

    private List<AnnotationInstance> processMessageHandlerAnnotations(List<AnnotationInstance> methodAnnotationInstances, AnnotationScannerContext context, AsyncApi26Document asyncApi) throws ClassNotFoundException {
        ArrayList<AnnotationInstance> consumedMessages = new ArrayList<AnnotationInstance>();
        FilteredIndexView index = context.getIndex();
        HashMap<String, JsonSchemaInfo> incomingMessages = new HashMap<String, JsonSchemaInfo>();
        ArrayList<ChannelInfo> channelInfos = new ArrayList<ChannelInfo>();
        HashMap<String, Scope> messageTypes = new HashMap<String, Scope>();
        for (AnnotationInstance handlerAnnotation : methodAnnotationInstances) {
            DotName annotationName = handlerAnnotation.name();
            List annotationValues = handlerAnnotation.values();
            MethodInfo methodInfo = (MethodInfo)handlerAnnotation.target();
            List methodParameters = methodInfo.parameterTypes();
            AnnotationInstance messageAnnotation = this.getMessageAnnotation(methodParameters, index);
            consumedMessages.add(messageAnnotation);
            ClassInfo messageClass = messageAnnotation.target().asClass();
            String messageClassSimpleName = messageClass.simpleName();
            String bindingKeys = this.getBindingKeys(handlerAnnotation, messageAnnotation);
            ExchangeType exchangeType = ExchangeTypeParser.getFromAnnotationInstance(messageAnnotation, index);
            String exchange = ExchangeParser.getFromAnnotationInstance(messageAnnotation);
            Scope scope = MessageScopeParser.getFromAnnotationInstance(messageAnnotation, index);
            boolean durable = this.getDurable(handlerAnnotation, index);
            boolean autoDelete = this.getAutoDelete(handlerAnnotation, index);
            String deadLetterQueue = DeadLetterQueueParser.getFromAnnotationInstance(messageAnnotation, index);
            Integer ttl = ExchangeTtlParser.getFromAnnotationInstance(messageAnnotation, index);
            boolean persistent = PersistentParser.getFromAnnotationInstance(messageAnnotation, index);
            org.jboss.jandex.Type responseType = ResponseParser.getFromAnnotationInstance(messageAnnotation, index);
            org.jboss.jandex.Type rpcResponseType = RpcResponseClassParser.getFromAnnotationInstance(messageAnnotation, index);
            boolean isGeneratedClass = this.isGeneratedClass(messageClass);
            JsonSchemaInfo jsonSchemaInfo = this.generateConsumedMessageJsonSchemaInfo(annotationName, messageClass.name().toString(), annotationValues, isGeneratedClass);
            ChannelInfo subscribeChannelInfo = ChannelInfoGenerator.generatePublishChannelInfo(exchange, bindingKeys, messageClassSimpleName, exchangeType, durable, autoDelete, RolesAllowedParser.getFromAnnotationInstance(handlerAnnotation, index), deadLetterQueue, ttl, responseType, persistent, rpcResponseType);
            messageTypes.put(messageClassSimpleName, scope);
            incomingMessages.put(messageClassSimpleName, jsonSchemaInfo);
            channelInfos.add(subscribeChannelInfo);
        }
        this.insertComponentSchemas(context, incomingMessages, asyncApi);
        this.createChannels(channelInfos, messageTypes, asyncApi);
        return consumedMessages;
    }

    private String getBindingKeys(AnnotationInstance handlerAnnotationInstance, AnnotationInstance messageAnnotation) {
        DotName dotName = handlerAnnotationInstance.name();
        if (DOT_NAME_SNAPSHOT_MESSAGE_HANDLER.equals((Object)dotName)) {
            return ResourceTypeParser.getFromAnnotationInstance(handlerAnnotationInstance);
        }
        if (DOT_NAME_MESSAGE_HANDLER.equals((Object)dotName)) {
            return BindingKeysParser.getFromAnnotationInstanceAsCsv(handlerAnnotationInstance, messageAnnotation);
        }
        throw new IllegalArgumentException("Unsupported annotation instance " + String.valueOf(dotName));
    }

    private boolean getDurable(AnnotationInstance handlerAnnotationInstance, FilteredIndexView indexView) {
        DotName dotName = handlerAnnotationInstance.name();
        if (DOT_NAME_SNAPSHOT_MESSAGE_HANDLER.equals((Object)dotName)) {
            return false;
        }
        if (DOT_NAME_MESSAGE_HANDLER.equals((Object)dotName)) {
            return QueueDurableParser.getFromAnnotationInstance(handlerAnnotationInstance, indexView);
        }
        throw new IllegalArgumentException("Unsupported annotation instance " + String.valueOf(dotName));
    }

    private boolean getAutoDelete(AnnotationInstance handlerAnnotationInstance, FilteredIndexView indexView) {
        DotName dotName = handlerAnnotationInstance.name();
        if (DOT_NAME_SNAPSHOT_MESSAGE_HANDLER.equals((Object)dotName)) {
            return true;
        }
        if (DOT_NAME_MESSAGE_HANDLER.equals((Object)dotName)) {
            return QueueAutoDeleteParser.getFromAnnotationInstance(handlerAnnotationInstance, indexView);
        }
        throw new IllegalArgumentException("Unsupported annotation instance " + String.valueOf(dotName));
    }

    private void processContextDefinitionReferencedSchemas(AnnotationScannerContext context, AsyncApi26Document asyncApi) {
        Map<String, GidAsyncApi26Schema> definitionSchemaMap = context.getDefinitionSchemaMap();
        asyncApi.getComponents().getSchemas().putAll(definitionSchemaMap);
        context.clearDefinitionSchemaMap();
    }

    private AsyncApi26Document setDocumentInfo(AsyncApi26Document document) {
        try {
            String projectSchemaId = SchemeIdGenerator.buildId(this.projectName);
            AsyncApi26InfoImpl info = new AsyncApi26InfoImpl();
            info.setTitle(this.projectName);
            info.setVersion(this.projectVersion);
            document.setId(projectSchemaId);
            document.setInfo((Info)info);
            document.setComponents((AsyncApiComponents)ComponentReader.create());
            return document;
        }
        catch (URISyntaxException e) {
            LOG.error("Could not generate schema ID", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private JsonSchemaInfo generateProducedMessageSchemaInfo(ClassInfo classInfo, FilteredIndexView index) throws ClassNotFoundException {
        String className = classInfo.name().toString();
        Class<?> loadedClass = this.loadClass(className);
        String classSimpleName = loadedClass.getSimpleName();
        boolean isGeneratedClass = this.isGeneratedClass(classInfo);
        Integer cacheTtl = this.getCacheTtl(classInfo, index);
        ObjectNode generatedSchema = this.schemaGenerator.generateSchema(loadedClass, new Type[0]);
        IrisAnnotationScanner.fixDocumentedRefProperties(className, generatedSchema);
        return new JsonSchemaInfo(null, classSimpleName, generatedSchema, null, isGeneratedClass, cacheTtl);
    }

    private JsonSchemaInfo generateConsumedMessageJsonSchemaInfo(DotName annotationName, String className, List<AnnotationValue> annotationValues, boolean isGeneratedClass) throws ClassNotFoundException {
        Class<?> loadedClass = this.loadClass(className);
        String eventSimpleName = loadedClass.getSimpleName();
        ObjectNode generatedSchema = this.schemaGenerator.generateSchema(loadedClass, new Type[0]);
        IrisAnnotationScanner.fixDocumentedRefProperties(className, generatedSchema);
        return new JsonSchemaInfo(annotationName, eventSimpleName, generatedSchema, annotationValues, isGeneratedClass, null);
    }

    private static void fixDocumentedRefProperties(String className, ObjectNode generatedSchema) {
        JsonNode properties = generatedSchema.get("properties");
        if (properties != null) {
            StreamSupport.stream(properties.spliterator(), false).filter(jsonNode -> jsonNode.has("allOf")).forEach(jsonNode -> {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                JsonNode allOf = jsonNode.get("allOf");
                allOf.forEach(allOfItem -> allOfItem.fields().forEachRemaining(stringJsonNodeEntry -> objectNode.set((String)stringJsonNodeEntry.getKey(), (JsonNode)stringJsonNodeEntry.getValue())));
                objectNode.remove("allOf");
            });
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    private SchemaGenerator initSchemaGenerator(AsyncApiConfig config) {
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.FLATTENED_ENUMS_FROM_JSONPROPERTY});
        GidOpenApiModule gidOpenApiModule = new GidOpenApiModule(GidOpenApiOption.IGNORING_HIDDEN_PROPERTIES, GidOpenApiOption.ENABLE_PROPERTY_NAME_OVERRIDES);
        JakartaValidationModule jakartaValidationModule = new JakartaValidationModule(new JakartaValidationOption[]{JakartaValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED, JakartaValidationOption.NOT_NULLABLE_METHOD_IS_REQUIRED, JakartaValidationOption.PREFER_IDN_EMAIL_FORMAT, JakartaValidationOption.INCLUDE_PATTERN_EXPRESSIONS});
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON).with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]).with((Module)jacksonModule).with((Module)jakartaValidationModule).with((Module)gidOpenApiModule);
        configBuilder.forTypesInGeneral().withCustomDefinitionProvider(CustomDefinitionProvider.convertTypesToObject(config.excludeFromSchemas()));
        configBuilder.forFields().withCustomDefinitionProvider(CustomDefinitionProvider.convertFieldsToObject(config.excludeFromSchemas()));
        configBuilder.with(Option.MAP_VALUES_AS_ADDITIONAL_PROPERTIES, new Option[0]);
        return new SchemaGenerator(configBuilder.build());
    }

    private AnnotationInstance getMessageAnnotation(List<org.jboss.jandex.Type> parameters, FilteredIndexView index) {
        List<AnnotationInstance> consumedEventTypes = parameters.stream().map(org.jboss.jandex.Type::name).map(index::getClassByName).filter(Objects::nonNull).map(classInfo -> classInfo.declaredAnnotation(DOT_NAME_MESSAGE)).filter(Objects::nonNull).toList();
        if (consumedEventTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format("Consumed Event not found for parameters %s", parameters));
        }
        if (consumedEventTypes.size() > 1) {
            throw new IllegalArgumentException("Multiple consumed Events detected. Message handler can only handle one event type.");
        }
        return consumedEventTypes.get(0);
    }

    private Integer getCacheTtl(ClassInfo classInfo, FilteredIndexView index) {
        AnnotationInstance annotationInstance = classInfo.declaredAnnotation(DOT_NAME_CACHED_MESSAGE);
        if (annotationInstance == null) {
            return null;
        }
        return CacheableTtlParser.getFromAnnotationInstance(annotationInstance, index);
    }
}

