/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.CustomPropertyDefinitionProvider;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDefinitionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomDefinitionProvider.class);
    private static final Pattern JAVA_UTIL_MAP_PATTERN = Pattern.compile("^(java\\.util\\.)(.*)(Map)(.*)\\<(.+),(.+)\\>$");
    private static final Set<String> DEFAULT_CONVERT_TO_OBJECT_CANDIDATES = Set.of("java.util.Map", "java.util.HashMap", "java.util.TreeMap", "com.fasterxml.jackson.databind.JsonNode");

    public static CustomDefinitionProviderV2 convertTypesToObject(Set<String> conversionCandidates) {
        HashSet<String> candidates = new HashSet<String>(DEFAULT_CONVERT_TO_OBJECT_CANDIDATES);
        candidates.addAll(conversionCandidates);
        return (javaType, context) -> {
            String fullTypeDescription = context.getTypeContext().getFullTypeDescription(javaType);
            SchemaGeneratorConfig generatorConfig = context.getGeneratorConfig();
            if (CustomDefinitionProvider.isInExcludeFromSchemas(fullTypeDescription, candidates)) {
                return new CustomDefinition(generatorConfig.createObjectNode().put(generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE), generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE_NULL)));
            }
            return null;
        };
    }

    public static CustomPropertyDefinitionProvider<FieldScope> convertFieldsToObject(Set<String> conversionCandidates) {
        HashSet<String> candidates = new HashSet<String>(DEFAULT_CONVERT_TO_OBJECT_CANDIDATES);
        candidates.addAll(conversionCandidates);
        return (scope, context) -> {
            String fullTypeDescription = scope.getFullTypeDescription();
            SchemaGeneratorConfig generatorConfig = context.getGeneratorConfig();
            if (CustomDefinitionProvider.isInExcludeFromSchemas(fullTypeDescription, candidates)) {
                Optional<String> mapTypeOptional = CustomDefinitionProvider.getMapType(fullTypeDescription);
                return mapTypeOptional.map(mapType -> {
                    ObjectNode definitionNode = generatorConfig.createObjectNode();
                    definitionNode.put(generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE), generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
                    definitionNode.put("existingJavaType", fullTypeDescription);
                    return new CustomPropertyDefinition(definitionNode);
                }).orElseGet(() -> new CustomPropertyDefinition(generatorConfig.createObjectNode().put(generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE), generatorConfig.getKeyword(SchemaKeyword.TAG_TYPE_NULL))));
            }
            return null;
        };
    }

    private static Optional<String> getMapType(String fullTypeDescription) {
        Matcher matcher = JAVA_UTIL_MAP_PATTERN.matcher(fullTypeDescription);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String mapType = matcher.group(2);
        return Optional.of(mapType + "Map");
    }

    private static boolean isInExcludeFromSchemas(String fullTypeDescription, Set<String> excludeFromSchemas) {
        return excludeFromSchemas.stream().anyMatch(fullTypeDescription::startsWith);
    }
}

