/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class JandexUtil {
    private JandexUtil() {
    }

    public static <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (isArray ? value.componentKind() : value.kind()) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public static <T> T value(AnnotationInstance annotation, String name, T defaultValue) {
        T value = JandexUtil.value(annotation, name);
        return value != null ? value : defaultValue;
    }

    public static String stringValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public static Optional<String> optionalStringValue(AnnotationInstance annotation, String propertyName) {
        String value = JandexUtil.stringValue(annotation, propertyName);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<List<String>> stringListValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value != null) {
            return Optional.of(new ArrayList<String>(Arrays.asList(value.asStringArray())));
        }
        return Optional.empty();
    }

    public static <T extends Enum<?>> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return JandexUtil.enumValue(value.asString(), clazz);
    }

    public static <T extends Enum<?>> T enumValue(String strVal, Class<T> clazz) {
        Enum[] constants;
        for (Enum t : constants = (Enum[])clazz.getEnumConstants()) {
            if (!t.toString().equals(strVal)) continue;
            return (T)t;
        }
        for (Enum t : constants) {
            if (!t.name().equalsIgnoreCase(strVal)) continue;
            return (T)t;
        }
        return null;
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return annotation.value("ref") != null;
    }
}

