/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.common;

import java.util.HashMap;
import java.util.Map;
import org.iris_events.common.Exchanges;

public class ErrorMessageDetailsBuilder {
    public static final String ERROR_ROUTING_KEY_SUFFIX = ".error";

    public static ErrorMessageDetails build(String originalMessageExchange, Map<String, Object> currentMessageHeaders, String currentServiceId, long currentTimestamp) {
        String exchange = Exchanges.ERROR.getValue();
        String routingKey = ErrorMessageDetailsBuilder.getRoutingKey(originalMessageExchange);
        Map<String, Object> messageHeaders = ErrorMessageDetailsBuilder.buildMessageHeaders(currentMessageHeaders, currentServiceId, currentTimestamp);
        return new ErrorMessageDetails(exchange, routingKey, messageHeaders);
    }

    private static Map<String, Object> buildMessageHeaders(Map<String, Object> currentMessageHeaders, String currentServiceId, long currentTimestamp) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>(currentMessageHeaders);
        messageHeaders.remove("x-jwt");
        messageHeaders.put("x-origin-event-type", currentMessageHeaders.get("x-event-type"));
        messageHeaders.put("x-event-type", Exchanges.ERROR.getValue());
        messageHeaders.put("x-current-service-id", currentServiceId);
        messageHeaders.put("x-server-timestamp", currentTimestamp);
        return messageHeaders;
    }

    private static String getRoutingKey(String originalMessageExchange) {
        return originalMessageExchange + ERROR_ROUTING_KEY_SUFFIX;
    }

    public record ErrorMessageDetails(String exchange, String routingKey, Map<String, Object> messageHeaders) {
    }
}

