/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.iris_events.context.EventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IrisJwtValidator {
    private static final Logger log = LoggerFactory.getLogger(IrisJwtValidator.class);
    private final EventContext eventContext;
    final JWTParser parser;

    @Inject
    public IrisJwtValidator(EventContext eventContext, JWTParser parser) {
        this.eventContext = eventContext;
        this.parser = parser;
    }

    public SecurityIdentity authenticate(Set<String> rolesAllowed) {
        Optional<String> optionalToken = this.getToken();
        if (optionalToken.isPresent()) {
            String token = optionalToken.get();
            SecurityIdentity securityIdentity = this.createSecurityIdentity(token);
            this.checkRolesAllowed(securityIdentity, rolesAllowed);
            return securityIdentity;
        }
        if (rolesAllowed.isEmpty()) {
            return null;
        }
        throw new UnauthorizedException("Client is not authorized");
    }

    private void checkRolesAllowed(SecurityIdentity securityIdentity, Set<String> rolesAllowed) {
        if (rolesAllowed.isEmpty()) {
            return;
        }
        boolean isAnyRoleAllowed = rolesAllowed.stream().anyMatch(role -> securityIdentity.hasRole(role) || "**".equals(role));
        if (!isAnyRoleAllowed) {
            throw new ForbiddenException("Role is not allowed");
        }
    }

    private SecurityIdentity createSecurityIdentity(String jwtToken) {
        try {
            TokenCredential jsonWebTokenCredential = new TokenCredential(jwtToken, "bearer");
            JsonWebToken jwtPrincipal = this.parser.parse(jwtToken);
            return QuarkusSecurityIdentity.builder().setPrincipal((Principal)jwtPrincipal).addCredential((Credential)jsonWebTokenCredential).addRoles(jwtPrincipal.getGroups()).addAttribute("quarkus.user", (Object)jwtPrincipal).build();
        }
        catch (ParseException e) {
            log.error("Authentication failed. Error message: " + e.getMessage(), (Throwable)e);
            throw new AuthenticationFailedException("Invalid authorization token", (Throwable)e);
        }
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.eventContext.getHeaders().get("x-jwt")).map(Object::toString);
    }
}

