/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.consumer;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.iris_events.runtime.channel.ChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class QueueDeclarator {
    private static final Logger log = LoggerFactory.getLogger(QueueDeclarator.class);
    ChannelService channelService;
    private final String channelId;

    @Inject
    public QueueDeclarator(@Named(value="consumerChannelService") ChannelService channelService) {
        this.channelService = channelService;
        this.channelId = UUID.randomUUID().toString();
    }

    public void declareQueueWithRecreateOnConflict(Channel channel, QueueDeclarationDetails details) throws IOException {
        String queueName = details.queueName;
        try {
            this.declareQueue(details);
        }
        catch (IOException e) {
            long msgCount = channel.messageCount(queueName);
            if (msgCount <= 0L) {
                log.warn("Queue declaration parameters changed. Trying to re-declare queue. Details: " + e.getCause().getMessage());
                channel.queueDelete(queueName, false, true);
                this.declareQueue(details);
            }
            log.error("The new settings of queue was not set, because was not empty! queue={}", (Object)queueName, (Object)e);
        }
    }

    private void declareQueue(QueueDeclarationDetails details) throws IOException {
        String queueName = details.queueName;
        boolean durable = details.durable;
        boolean exclusive = details.exclusive;
        boolean autoDelete = details.autoDelete;
        Map<String, Object> arguments = details.arguments;
        Channel channel = this.channelService.getOrCreateChannelById(this.channelId);
        AMQP.Queue.DeclareOk declareOk = channel.queueDeclare(queueName, durable, exclusive, autoDelete, arguments);
        log.info("Queue declared. name: {}, durable: {}, autoDelete: {}, consumers: {}, message count: {}", new Object[]{declareOk.getQueue(), durable, autoDelete, declareOk.getConsumerCount(), declareOk.getMessageCount()});
    }

    public record QueueDeclarationDetails(String queueName, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
    }
}

