/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.context;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.iris_events.context.EventContextHolder;

@ApplicationScoped
public class EventContext {
    private final ThreadLocal<EventContextHolder> eventContextThreadLocal = new ThreadLocal();

    public EventContext() {
        this.eventContextThreadLocal.set(new EventContextHolder());
    }

    private Optional<EventContextHolder> findEventContextHolder() {
        return Optional.ofNullable(this.eventContextThreadLocal.get());
    }

    private EventContextHolder getOrCreateEventContextHolder() {
        return this.findEventContextHolder().orElseGet(EventContextHolder::new);
    }

    public void setBasicProperties(AMQP.BasicProperties properties) {
        EventContextHolder eventContextHolder = this.getOrCreateEventContextHolder();
        eventContextHolder.setAmqpBasicProperties(properties);
        this.eventContextThreadLocal.set(eventContextHolder);
    }

    public void setEnvelope(Envelope envelope) {
        EventContextHolder eventContextHolder = this.getOrCreateEventContextHolder();
        eventContextHolder.setEnvelope(envelope);
        this.eventContextThreadLocal.set(eventContextHolder);
    }

    public AMQP.BasicProperties getAmqpBasicProperties() {
        return this.findEventContextHolder().map(EventContextHolder::getAmqpBasicProperties).orElse(null);
    }

    public Envelope getEnvelope() {
        return this.findEventContextHolder().map(EventContextHolder::getEnvelope).orElse(null);
    }

    public String getExchange() {
        return Optional.ofNullable(this.getEnvelope()).map(Envelope::getExchange).orElse(null);
    }

    public String getRoutingKey() {
        return Optional.ofNullable(this.getEnvelope()).map(Envelope::getRoutingKey).orElse(null);
    }

    public Map<String, Object> getHeaders() {
        return this.findEventContextHolder().map(EventContextHolder::getAmqpBasicProperties).map(AMQP.BasicProperties::getHeaders).orElse(Collections.emptyMap());
    }

    public Optional<String> getCorrelationId() {
        return this.findEventContextHolder().map(EventContextHolder::getAmqpBasicProperties).map(AMQP.BasicProperties::getCorrelationId);
    }

    public Optional<String> getUserId() {
        return this.getHeaderValue("x-user-id");
    }

    public Optional<String> getMessageId() {
        return Optional.ofNullable(this.getAmqpBasicProperties().getMessageId());
    }

    public Optional<String> getSessionId() {
        return this.getHeaderValue("x-session-id");
    }

    public Integer getRetryCount() {
        return this.getHeaderValue("x-retry-count").map(Integer::valueOf).orElse(0);
    }

    public Optional<String> getHeaderValue(String header) {
        return this.findEventContextHolder().map(EventContextHolder::getAmqpBasicProperties).map(AMQP.BasicProperties::getHeaders).filter(headers -> headers.containsKey(header)).map(headers -> headers.get(header)).map(Object::toString);
    }

    public void setSubscriptionId(String subscriptionId) {
        this.setHeader("x-subscription-id", subscriptionId);
    }

    public void setHeader(String key, Object value) {
        AMQP.BasicProperties basicProperties = this.findEventContextHolder().map(EventContextHolder::getAmqpBasicProperties).orElseThrow(() -> new IllegalStateException("AMQP.BasicProperties not set for the message context."));
        AMQP.BasicProperties.Builder builder = basicProperties.builder();
        HashMap<String, Object> headers = new HashMap<String, Object>(basicProperties.getHeaders());
        headers.put(key, value);
        AMQP.BasicProperties modifiedBasicProperties = builder.headers(headers).build();
        this.eventContextThreadLocal.get().setAmqpBasicProperties(modifiedBasicProperties);
    }
}

