/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.routing;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Message;
import org.iris_events.annotations.Scope;
import org.iris_events.asyncapi.parsers.ExchangeParser;
import org.iris_events.asyncapi.parsers.ExchangeTypeParser;
import org.iris_events.asyncapi.parsers.PersistentParser;
import org.iris_events.asyncapi.parsers.RoutingKeyParser;
import org.iris_events.common.Exchanges;
import org.iris_events.context.EventContext;
import org.iris_events.exception.IrisSendException;
import org.iris_events.producer.RoutingDetails;
import org.iris_events.runtime.ExchangeNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RoutingDetailsProvider {
    private static final Logger log = LoggerFactory.getLogger(RoutingDetailsProvider.class);
    ExchangeNameProvider exchangeNameProvider;
    EventContext eventContext;

    @Inject
    public RoutingDetailsProvider(ExchangeNameProvider exchangeNameProvider, EventContext eventContext) {
        this.exchangeNameProvider = exchangeNameProvider;
        this.eventContext = eventContext;
    }

    public RoutingDetails getRoutingDetailsForClientScope(Message messageAnnotation, Scope scope, String userId) {
        String exchange = Optional.ofNullable(userId).map(u -> Exchanges.USER.getValue()).orElseGet(() -> switch (scope) {
            case Scope.USER -> Exchanges.USER.getValue();
            case Scope.SESSION -> Exchanges.SESSION.getValue();
            case Scope.BROADCAST -> Exchanges.BROADCAST.getValue();
            default -> throw new IrisSendException("Message scope " + scope + " not supported!");
        });
        String eventName = ExchangeParser.getFromAnnotationClass((Message)messageAnnotation);
        String routingKey = String.format("%s.%s", eventName, exchange);
        boolean persistent = PersistentParser.getFromAnnotationClass((Message)messageAnnotation);
        RoutingDetails.MiscRoutingDetailsBuilder builder = new RoutingDetails.Builder().eventName(eventName).exchange(exchange).exchangeType(ExchangeType.TOPIC).routingKey(routingKey).scope(scope).userId(userId).persistent(persistent);
        Optional<String> optionalSessionId = this.eventContext.getSessionId();
        Optional<String> optionalUserId = this.eventContext.getUserId();
        optionalSessionId.ifPresent(builder::sessionId);
        optionalUserId.ifPresent(builder::userId);
        return builder.build();
    }

    public RoutingDetails getRoutingDetailsFromAnnotation(Message messageAnnotation, Scope scope, String userId, boolean propagate) {
        ExchangeType exchangeType = ExchangeTypeParser.getFromAnnotationClass((Message)messageAnnotation);
        String eventName = ExchangeParser.getFromAnnotationClass((Message)messageAnnotation);
        String routingKey = this.getRoutingKey(messageAnnotation, exchangeType);
        boolean persistent = PersistentParser.getFromAnnotationClass((Message)messageAnnotation);
        RoutingDetails.MiscRoutingDetailsBuilder routingDetailsBuilder = new RoutingDetails.Builder().eventName(eventName).exchange(eventName).exchangeType(exchangeType).routingKey(routingKey).scope(scope).userId(userId).persistent(persistent).propagate(propagate);
        return routingDetailsBuilder.build();
    }

    public RoutingDetails getRpcRoutingDetails(Message messageAnnotation, String replyTo) {
        String eventName = ExchangeParser.getFromAnnotationClass((Message)messageAnnotation);
        boolean persistent = PersistentParser.getFromAnnotationClass((Message)messageAnnotation);
        RoutingDetails.MiscRoutingDetailsBuilder routingDetailsBuilder = new RoutingDetails.Builder().eventName(eventName).exchange(this.exchangeNameProvider.getRpcResponseExchangeName(eventName)).exchangeType(ExchangeType.FANOUT).routingKey(replyTo).scope(Scope.INTERNAL).persistent(persistent).propagate(true);
        RoutingDetails routingDetails = routingDetailsBuilder.build();
        log.info(String.format("Built RPC routing details: %s", routingDetails.toString()));
        return routingDetails;
    }

    private String getRoutingKey(Message messageAnnotation, ExchangeType exchangeType) {
        if (exchangeType == ExchangeType.FANOUT) {
            return "";
        }
        return RoutingKeyParser.getFromAnnotationClass((Message)messageAnnotation);
    }
}

