/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.connection;

import com.rabbitmq.client.Connection;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.iris_events.exception.IrisConnectionException;
import org.iris_events.health.IrisLivenessCheck;
import org.iris_events.health.IrisReadinessCheck;
import org.iris_events.runtime.InstanceInfoProvider;
import org.iris_events.runtime.configuration.IrisConfig;
import org.iris_events.runtime.connection.ConnectionFactoryProvider;
import org.slf4j.Logger;

public abstract class AbstractConnectionProvider {
    private ConnectionFactoryProvider connectionFactoryProvider;
    private InstanceInfoProvider instanceInfoProvider;
    private IrisConfig config;
    private IrisReadinessCheck readinessCheck;
    private IrisLivenessCheck livenessCheck;
    private Logger log;
    private AtomicBoolean connecting;
    protected Connection connection;

    public AbstractConnectionProvider() {
    }

    public AbstractConnectionProvider(ConnectionFactoryProvider connectionFactoryProvider, InstanceInfoProvider instanceInfoProvider, IrisConfig config, IrisReadinessCheck readinessCheck, IrisLivenessCheck livenessCheck, Logger log) {
        this.connectionFactoryProvider = connectionFactoryProvider;
        this.instanceInfoProvider = instanceInfoProvider;
        this.config = config;
        this.readinessCheck = readinessCheck;
        this.livenessCheck = livenessCheck;
        this.log = log;
        this.connecting = new AtomicBoolean(false);
    }

    public Connection getConnection() {
        if (this.isConnectionOpen() || this.isConnecting()) {
            return this.connection;
        }
        this.log.info("Establishing new AMQP connection with resilience.");
        this.setConnecting(true);
        this.connection = this.connectWithResilience(this.config.getBackoffIntervalMillis(), this.config.getBackoffMultiplier(), this.config.getMaxRetries());
        return this.connection;
    }

    protected abstract String getConnectionNamePrefix();

    private Connection connectWithResilience(long initialInterval, double multiplier, int maxRetries) {
        IntervalFunction intervalFn = IntervalFunction.ofExponentialBackoff((long)initialInterval, (double)multiplier);
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(maxRetries).intervalFunction(intervalFn).retryExceptions(new Class[]{IrisConnectionException.class}).failAfterMaxAttempts(true).build();
        Retry retry = Retry.of((String)"executeConnection", (RetryConfig)retryConfig);
        this.registerEventPublisher(retry.getEventPublisher());
        Function connectFn = Retry.decorateFunction((Retry)retry, v -> this.connect());
        return (Connection)connectFn.apply(null);
    }

    private void registerEventPublisher(Retry.EventPublisher eventPublisher) {
        eventPublisher.onRetry(onRetryEvent -> {
            this.log.warn(String.format("Establishing AMQP connection - retry. attempt: %d/%d, interval: %ds, last exception: %s", onRetryEvent.getNumberOfRetryAttempts(), this.config.getMaxRetries(), onRetryEvent.getWaitInterval().getSeconds(), onRetryEvent.getLastThrowable()));
            this.setConnecting(true);
            this.setTimedOut(false);
        });
        eventPublisher.onError(onErrorEvent -> {
            this.log.error(String.format("Error establishing AMQP connection. attempt: %d/%d", onErrorEvent.getNumberOfRetryAttempts(), this.config.getMaxRetries()));
            this.setConnecting(false);
            this.setTimedOut(true);
        });
        eventPublisher.onSuccess(onSuccessEvent -> {
            this.log.info(String.format("AMQP connection established. attempt: %d/%d", onSuccessEvent.getNumberOfRetryAttempts(), this.config.getMaxRetries()));
            this.setConnecting(false);
            this.setTimedOut(false);
        });
        eventPublisher.onIgnoredError(onIgnoredEvent -> this.log.error(String.format("Ignored exception encountered while establishing AMQP connection. attempt: %d/%d, last exception: %s", onIgnoredEvent.getNumberOfRetryAttempts(), this.config.getMaxRetries(), onIgnoredEvent.getLastThrowable())));
    }

    private Connection connect() {
        try {
            Connection connection = this.connectionFactoryProvider.getConnectionFactory().newConnection(this.getConnectionNamePrefix() + this.instanceInfoProvider.getInstanceName());
            this.setConnecting(false);
            this.setTimedOut(false);
            return connection;
        }
        catch (IOException | TimeoutException e) {
            throw new IrisConnectionException("Could not create new AMQP connection", (Throwable)e);
        }
    }

    private void setConnecting(boolean connecting) {
        this.connecting.set(connecting);
        this.readinessCheck.setConnecting(connecting);
    }

    private void setTimedOut(boolean timedOut) {
        this.readinessCheck.setTimedOut(timedOut);
        this.livenessCheck.setTimedOut(timedOut);
    }

    private boolean isConnecting() {
        return this.connecting.get();
    }

    private boolean isConnectionOpen() {
        return this.connection != null && this.connection.isOpen();
    }
}

