/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.requeue;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.iris_events.common.Exchanges;
import org.iris_events.common.Queues;
import org.iris_events.context.IrisContext;
import org.iris_events.exception.MessagingException;
import org.iris_events.runtime.QueueNameProvider;
import org.iris_events.runtime.TimestampProvider;
import org.iris_events.runtime.channel.ChannelService;
import org.iris_events.runtime.configuration.IrisConfig;

@ApplicationScoped
public class MessageRequeueHandler {
    private final Channel channel;
    private final IrisConfig config;
    private final QueueNameProvider queueNameProvider;
    private final TimestampProvider timestampProvider;

    @Inject
    public MessageRequeueHandler(@Named(value="producerChannelService") ChannelService channelService, IrisConfig config, QueueNameProvider queueNameProvider, TimestampProvider timestampProvider) throws IOException {
        this.config = config;
        this.queueNameProvider = queueNameProvider;
        this.timestampProvider = timestampProvider;
        String channelId = UUID.randomUUID().toString();
        this.channel = channelService.getOrCreateChannelById(channelId);
    }

    public void enqueueWithBackoff(IrisContext irisContext, Delivery message, MessagingException messagingException, boolean shouldNotifyFrontend) throws IOException {
        Delivery newMessage = this.getMessageWithNewHeaders(irisContext, message, messagingException, shouldNotifyFrontend);
        this.channel.basicPublish(Exchanges.RETRY.getValue(), Queues.RETRY.getValue(), newMessage.getProperties(), newMessage.getBody());
    }

    private Delivery getMessageWithNewHeaders(IrisContext irisContext, Delivery message, MessagingException messagingException, boolean shouldNotifyFrontend) {
        AMQP.BasicProperties properties = message.getProperties();
        Map headers = properties.getHeaders();
        HashMap<String, Object> newHeaders = new HashMap<String, Object>(headers);
        newHeaders.put("x-original-exchange", message.getEnvelope().getExchange());
        newHeaders.put("x-original-routing-key", message.getEnvelope().getRoutingKey());
        newHeaders.put("x-max-retries", this.config.getRetryMaxCount());
        newHeaders.put("x-error-code", messagingException.getClientCode());
        newHeaders.put("x-error-type", messagingException.getErrorType().name());
        newHeaders.put("x-error-message", messagingException.getMessage());
        newHeaders.put("x-notify-client", shouldNotifyFrontend);
        newHeaders.put("x-server-timestamp", this.timestampProvider.getCurrentTimestamp());
        String queueName = this.queueNameProvider.getQueueName(irisContext);
        newHeaders.put("x-original-queue", queueName);
        Optional<String> deadLetterExchangeName = irisContext.getDeadLetterExchangeName();
        if (deadLetterExchangeName.isPresent()) {
            String deadLetterRoutingKey = irisContext.getDeadLetterRoutingKey(queueName);
            newHeaders.put("x-dead-letter-exchange", deadLetterExchangeName.get());
            newHeaders.put("x-dead-letter-routing-key", deadLetterRoutingKey);
        }
        AMQP.BasicProperties basicProperties = new AMQP.BasicProperties().builder().headers(newHeaders).appId(properties.getAppId()).correlationId(properties.getCorrelationId()).messageId(properties.getMessageId()).clusterId(properties.getClusterId()).contentEncoding(properties.getContentEncoding()).contentType(properties.getContentType()).deliveryMode(properties.getDeliveryMode()).expiration(properties.getExpiration()).priority(properties.getPriority()).replyTo(properties.getReplyTo()).timestamp(properties.getTimestamp()).type(properties.getType()).build();
        return new Delivery(message.getEnvelope(), basicProperties, message.getBody());
    }
}

