/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime;

import com.rabbitmq.client.AMQP;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.iris_events.annotations.Scope;
import org.iris_events.common.DeliveryMode;
import org.iris_events.context.EventAppContext;
import org.iris_events.context.EventContext;
import org.iris_events.producer.CorrelationIdProvider;
import org.iris_events.producer.RoutingDetails;
import org.iris_events.runtime.EventAppInfoProvider;
import org.iris_events.runtime.InstanceInfoProvider;
import org.iris_events.runtime.TimestampProvider;

@ApplicationScoped
public class BasicPropertiesProvider {
    public static final String SERVICE_ID_UNAVAILABLE_FALLBACK = "N/A";
    @Inject
    EventAppInfoProvider eventAppInfoProvider;
    @Inject
    EventContext eventContext;
    @Inject
    CorrelationIdProvider correlationIdProvider;
    @Inject
    InstanceInfoProvider instanceInfoProvider;
    @Inject
    TimestampProvider timestampProvider;

    public AMQP.BasicProperties getOrCreateAmqpBasicProperties(RoutingDetails routingDetails) {
        Optional<EventAppContext> eventAppContext = Optional.ofNullable(this.eventAppInfoProvider.getEventAppContext());
        String serviceId = eventAppContext.map(EventAppContext::getId).orElse(SERVICE_ID_UNAVAILABLE_FALLBACK);
        AMQP.BasicProperties basicProperties = Optional.ofNullable(this.eventContext.getAmqpBasicProperties()).orElse(this.createAmqpBasicProperties(serviceId));
        return this.buildAmqpBasicPropertiesWithCustomHeaders(basicProperties, serviceId, routingDetails);
    }

    private AMQP.BasicProperties createAmqpBasicProperties(String serviceId) {
        return new AMQP.BasicProperties().builder().correlationId(this.correlationIdProvider.getCorrelationId()).headers(Map.of("x-origin-service-id", serviceId)).build();
    }

    private AMQP.BasicProperties buildAmqpBasicPropertiesWithCustomHeaders(AMQP.BasicProperties basicProperties, String serviceId, RoutingDetails routingDetails) {
        Integer cacheTtl;
        String subscriptionId;
        String eventName = routingDetails.getEventName();
        Scope scope = routingDetails.getScope();
        String userId = routingDetails.getUserId();
        String sessionId = routingDetails.getSessionId();
        boolean propagate = routingDetails.getPropagate();
        String hostName = this.instanceInfoProvider.getInstanceName();
        HashMap<String, Object> headers = new HashMap<String, Object>(Optional.ofNullable(basicProperties.getHeaders()).orElse(new HashMap()));
        headers.put("x-current-service-id", serviceId);
        headers.put("x-instance-id", hostName);
        headers.put("x-event-type", eventName);
        headers.put("x-server-timestamp", this.timestampProvider.getCurrentTimestamp());
        if (scope != Scope.INTERNAL) {
            headers.remove("x-jwt");
        }
        if ((subscriptionId = routingDetails.getSubscriptionId()) != null) {
            headers.put("x-subscription-id", subscriptionId);
        }
        if ((cacheTtl = routingDetails.getCacheTtl()) != null) {
            headers.put("x-cache-ttl", cacheTtl);
        }
        AMQP.BasicProperties.Builder builder = basicProperties.builder();
        if (userId != null || sessionId != null) {
            builder.correlationId(this.correlationIdProvider.getCorrelationId());
            headers.put("x-origin-service-id", serviceId);
            headers.remove("x-router");
            Optional.ofNullable(userId).ifPresent(id -> headers.put("x-user-id", id));
            Optional.ofNullable(sessionId).ifPresent(id -> headers.put("x-session-id", id));
        }
        if (!propagate) {
            builder.correlationId(this.correlationIdProvider.getCorrelationId());
        }
        builder.deliveryMode(Integer.valueOf(this.getDeliveryMode(routingDetails)));
        return builder.headers(headers).build();
    }

    private int getDeliveryMode(RoutingDetails routingDetails) {
        return routingDetails.getPersistent() ? DeliveryMode.PERSISTENT.getValue() : DeliveryMode.NON_PERSISTENT.getValue();
    }
}

