/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import io.quarkus.security.AuthenticationFailedException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.ValidationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.iris_events.common.ErrorMessageDetailsBuilder;
import org.iris_events.common.ErrorType;
import org.iris_events.common.message.ErrorMessage;
import org.iris_events.context.EventContext;
import org.iris_events.context.IrisContext;
import org.iris_events.exception.BadPayloadException;
import org.iris_events.exception.ClientException;
import org.iris_events.exception.ForbiddenException;
import org.iris_events.exception.IrisSendException;
import org.iris_events.exception.IrisTransactionException;
import org.iris_events.exception.MessagingException;
import org.iris_events.exception.SecurityException;
import org.iris_events.exception.ServerException;
import org.iris_events.exception.UnauthorizedException;
import org.iris_events.runtime.TimestampProvider;
import org.iris_events.runtime.requeue.MessageRequeueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IrisExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(IrisExceptionHandler.class);
    public static final String AUTHENTICATION_FAILED_CLIENT_CODE = "AUTHENTICATION_FAILED";
    public static final String FORBIDDEN_CLIENT_CODE = "FORBIDDEN";
    public static final String UNAUTHORIZED_CLIENT_CODE = "UNAUTHORIZED";
    public static final String SERVER_ERROR_CLIENT_CODE = "INTERNAL_SERVER_ERROR";
    private final ObjectMapper objectMapper;
    private final EventContext eventContext;
    private final MessageRequeueHandler retryEnqueuer;
    private final TimestampProvider timestampProvider;

    @Inject
    public IrisExceptionHandler(ObjectMapper objectMapper, EventContext eventContext, MessageRequeueHandler retryEnqueuer, TimestampProvider timestampProvider) {
        this.objectMapper = objectMapper;
        this.eventContext = eventContext;
        this.retryEnqueuer = retryEnqueuer;
        this.timestampProvider = timestampProvider;
    }

    public void handleException(IrisContext irisContext, Delivery message, Channel channel, Throwable throwable) {
        try {
            if (throwable instanceof IrisTransactionException) {
                log.error("Exception completing send transaction when sending/forwarding event.", throwable);
                throw (IrisTransactionException)throwable;
            }
            if (throwable instanceof IrisSendException) {
                log.error("Exception sending/forwarding event.", throwable);
                throw (IrisSendException)throwable;
            }
            if (throwable instanceof SecurityException) {
                this.handleSecurityException(message, channel, (SecurityException)throwable);
            } else if (throwable instanceof java.lang.SecurityException) {
                this.handleSecurityException(message, channel, (java.lang.SecurityException)throwable);
            } else if (throwable instanceof InvalidFormatException) {
                BadPayloadException clientException = new BadPayloadException(ErrorType.BAD_PAYLOAD.name(), throwable.getMessage());
                this.handleBadMessageException(message, channel, (ClientException)clientException);
            } else if (throwable instanceof ValidationException) {
                BadPayloadException clientException = new BadPayloadException(ErrorType.BAD_PAYLOAD.name(), throwable.getMessage());
                this.handleBadMessageException(message, channel, (ClientException)clientException);
            } else if (throwable instanceof ClientException) {
                this.handleBadMessageException(message, channel, (ClientException)throwable);
            } else {
                this.handleServerException(irisContext, message, channel, throwable);
            }
        }
        catch (IOException exception) {
            log.error("IOException encountered while handling error. Handled message will be requeued.", (Throwable)exception);
            throw new UncheckedIOException(exception);
        }
    }

    private void handleSecurityException(Delivery message, Channel channel, java.lang.SecurityException securityException) throws IOException {
        this.handleSecurityException(message, channel, IrisExceptionHandler.getSecurityException(securityException));
    }

    private void handleSecurityException(Delivery message, Channel channel, SecurityException exception) throws IOException {
        String originalExchange = message.getEnvelope().getExchange();
        String originalRoutingKey = message.getEnvelope().getRoutingKey();
        log.error(String.format("Security exception thrown. Message with given binding keys(s) is being discarded (acknowledged). error: '%s', exchange: '%s', routingKey: '%s', errorType: '%s'", exception.getClientCode(), originalExchange, originalRoutingKey, exception.getClass().getName()), (Throwable)exception);
        this.acknowledgeMessageAndSendError(message, channel, (MessagingException)exception);
    }

    private void handleBadMessageException(Delivery message, Channel channel, ClientException exception) throws IOException {
        String originalExchange = message.getEnvelope().getExchange();
        String originalRoutingKey = message.getEnvelope().getRoutingKey();
        log.error(String.format("Bad message received, message with given binding keys(s) is being discarded (acknowledged). error: '%s', exchange: '%s', routingKey: '%s'", exception.getClientCode(), originalExchange, originalRoutingKey), (Throwable)exception);
        this.acknowledgeMessageAndSendError(message, channel, (MessagingException)exception);
    }

    private void handleServerException(IrisContext irisContext, Delivery message, Channel channel, Throwable throwable) throws IOException {
        ServerException serverException;
        ServerException exception = throwable instanceof ServerException ? (serverException = (ServerException)throwable) : new ServerException(SERVER_ERROR_CLIENT_CODE, throwable.getMessage(), false, throwable.getCause());
        if (exception.shouldRetry()) {
            log.error("Encountered server exception while processing message. Sending to retry exchange.", throwable);
            this.acknowledgeMessage(channel, message);
            this.retryEnqueuer.enqueueWithBackoff(irisContext, message, (MessagingException)exception, exception.shouldNotifyFrontend());
        } else if (exception.shouldNotifyFrontend()) {
            log.error("Encountered server exception while processing message. Notifying client with no retries.", throwable);
            this.acknowledgeMessageAndSendError(message, channel, (MessagingException)exception);
        } else {
            log.error("Encountered server exception while processing message.", throwable);
            this.acknowledgeMessage(channel, message);
        }
    }

    private void acknowledgeMessageAndSendError(Delivery message, Channel channel, MessagingException exception) throws IOException {
        ErrorMessage errorMessage = new ErrorMessage(exception.getErrorType(), exception.getClientCode(), exception.getMessage());
        this.sendErrorMessage(errorMessage, message, channel);
        this.acknowledgeMessage(channel, message);
    }

    private void acknowledgeMessage(Channel channel, Delivery message) throws IOException {
        channel.basicAck(message.getEnvelope().getDeliveryTag(), false);
    }

    private void sendErrorMessage(ErrorMessage message, Delivery consumedMessage, Channel channel) {
        String originalExchange = consumedMessage.getEnvelope().getExchange();
        HashMap<String, Object> originalMessageHeaders = new HashMap<String, Object>(this.eventContext.getHeaders());
        long currentTimestamp = this.timestampProvider.getCurrentTimestamp();
        ErrorMessageDetailsBuilder.ErrorMessageDetails errorMessageDetails = ErrorMessageDetailsBuilder.build((String)originalExchange, originalMessageHeaders, (long)currentTimestamp);
        Map messageHeaders = errorMessageDetails.messageHeaders();
        AMQP.BasicProperties basicProperties = consumedMessage.getProperties().builder().headers(messageHeaders).build();
        try {
            channel.basicPublish(errorMessageDetails.exchange(), errorMessageDetails.routingKey(), basicProperties, this.objectMapper.writeValueAsBytes((Object)message));
        }
        catch (IOException e) {
            log.error("Unable to write error message as bytes. Discarding error message. Message: {}", (Object)message);
        }
    }

    public static SecurityException getSecurityException(java.lang.SecurityException securityException) {
        String message = securityException.getMessage();
        Throwable cause = securityException.getCause();
        if (securityException instanceof AuthenticationFailedException) {
            return new UnauthorizedException(AUTHENTICATION_FAILED_CLIENT_CODE, message, cause);
        }
        if (securityException instanceof io.quarkus.security.ForbiddenException) {
            return new ForbiddenException(FORBIDDEN_CLIENT_CODE, message, cause);
        }
        if (securityException instanceof io.quarkus.security.UnauthorizedException) {
            return new UnauthorizedException(UNAUTHORIZED_CLIENT_CODE, message, cause);
        }
        return new UnauthorizedException(UNAUTHORIZED_CLIENT_CODE, message, cause);
    }
}

