/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.auth;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.cdi.NullJsonWebToken;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@Priority(value=5)
@Alternative
@RequestScoped
public class IrisJsonWebTokenProducer {
    private static final Logger LOG = Logger.getLogger(IrisJsonWebTokenProducer.class);
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    JsonWebToken currentAccessToken() {
        if (this.identity.isAnonymous()) {
            return new NullJsonWebToken();
        }
        if (this.identity.getPrincipal() instanceof JsonWebToken) {
            return (JsonWebToken)this.identity.getPrincipal();
        }
        throw new IllegalStateException("Current principal " + this.identity.getPrincipal() + " is not a JSON web token");
    }
}

