/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.context;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Scope;
import org.iris_events.common.Queues;

public final class IrisContext {
    private static final ExchangeType DEFAULT_EXCHANGE_TYPE = ExchangeType.FANOUT;
    private String name;
    private List<String> bindingKeys;
    private ExchangeType exchangeType;
    private Scope scope;
    private boolean durable;
    private boolean autoDelete;
    private boolean consumerOnEveryInstance;
    private int prefetch;
    private long ttl;
    private String deadLetterQueue;
    private Set<String> handlerRolesAllowed;
    private String rpcResponseEventName;

    public IrisContext() {
    }

    public IrisContext(String name, List<String> bindingKeys, ExchangeType exchangeType, Scope scope, boolean durable, boolean autoDelete, boolean consumerOnEveryInstance, int prefetch, long ttl, String deadLetterQueue, Set<String> handlerRolesAllowed, String rpcResponseEventName) {
        this.name = name;
        this.bindingKeys = bindingKeys;
        this.exchangeType = exchangeType;
        this.scope = scope;
        this.durable = durable;
        this.autoDelete = autoDelete;
        this.consumerOnEveryInstance = consumerOnEveryInstance;
        this.prefetch = prefetch;
        this.ttl = ttl;
        this.deadLetterQueue = deadLetterQueue;
        this.handlerRolesAllowed = handlerRolesAllowed;
        this.rpcResponseEventName = rpcResponseEventName;
    }

    public ExchangeType exchangeType() {
        return Optional.ofNullable(this.exchangeType).orElse(DEFAULT_EXCHANGE_TYPE);
    }

    public boolean isFrontendMessage() {
        return this.scope == Scope.FRONTEND;
    }

    public Optional<String> getDeadLetterQueueName() {
        String deadLetterQueue = this.getDeadLetterQueue();
        if (deadLetterQueue.isBlank()) {
            return Optional.empty();
        }
        if (this.isFrontendMessage()) {
            return Optional.empty();
        }
        return Optional.of(deadLetterQueue);
    }

    public boolean isCustomDeadLetterQueue() {
        return this.getDeadLetterQueueName().map(deadLetterQueueName -> !this.isDefaultDeadLetterQueueName((String)deadLetterQueueName)).orElse(false);
    }

    private boolean isDefaultDeadLetterQueueName(String deadLetterQueueName) {
        return deadLetterQueueName.equals(Queues.DEAD_LETTER.getValue());
    }

    public Optional<String> getDeadLetterExchangeName() {
        return this.getDeadLetterQueueName();
    }

    public String getDeadLetterRoutingKey(String queueName) {
        return "dead." + queueName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getBindingKeys() {
        return this.bindingKeys;
    }

    public void setBindingKeys(List<String> bindingKeys) {
        this.bindingKeys = bindingKeys;
    }

    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(ExchangeType exchangeType) {
        this.exchangeType = exchangeType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isConsumerOnEveryInstance() {
        return this.consumerOnEveryInstance;
    }

    public void setConsumerOnEveryInstance(boolean consumerOnEveryInstance) {
        this.consumerOnEveryInstance = consumerOnEveryInstance;
    }

    public int getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(int prefetch) {
        this.prefetch = prefetch;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue.trim();
    }

    public Set<String> getHandlerRolesAllowed() {
        return this.handlerRolesAllowed;
    }

    public void setHandlerRolesAllowed(Set<String> handlerRolesAllowed) {
        this.handlerRolesAllowed = handlerRolesAllowed;
    }

    public String getRpcResponseEventName() {
        return this.rpcResponseEventName;
    }

    public void setRpcResponseEventName(String rpcResponseEventName) {
        this.rpcResponseEventName = rpcResponseEventName;
    }

    public boolean isRpc() {
        return this.rpcResponseEventName != null && !this.rpcResponseEventName.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IrisContext that = (IrisContext)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.bindingKeys, that.bindingKeys) && Objects.equals(this.exchangeType, that.exchangeType) && Objects.equals(this.scope, that.scope) && this.durable == that.durable && this.autoDelete == that.autoDelete && this.consumerOnEveryInstance == that.consumerOnEveryInstance && this.prefetch == that.prefetch && this.ttl == that.ttl && Objects.equals(this.deadLetterQueue, that.deadLetterQueue) && Objects.equals(this.handlerRolesAllowed, that.handlerRolesAllowed) && Objects.equals(this.rpcResponseEventName, that.rpcResponseEventName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bindingKeys, this.exchangeType, this.scope, this.durable, this.autoDelete, this.consumerOnEveryInstance, this.prefetch, this.ttl, this.deadLetterQueue, this.handlerRolesAllowed, this.rpcResponseEventName);
    }

    public String toString() {
        StringJoiner handlerRolesJoiner = new StringJoiner(", ", "[", "]");
        if (this.handlerRolesAllowed != null) {
            this.handlerRolesAllowed.forEach(handlerRolesJoiner::add);
        }
        return "IrisContext[name=" + this.name + ", bindingKeys=" + this.bindingKeys + ", exchangeType=" + this.exchangeType + ", scope=" + this.scope + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + ", consumerOnEveryInstance=" + this.consumerOnEveryInstance + ", prefetch=" + this.prefetch + ", ttl=" + this.ttl + ", deadLetterQueue=" + this.deadLetterQueue + ", handlerRolesAllowed=" + handlerRolesJoiner + ", rpcResponseEventName=" + this.rpcResponseEventName + "]";
    }
}

