/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.producer;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Scope;
import org.iris_events.consumer.ExchangeDeclarator;
import org.iris_events.producer.ProducerDefinedExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProducedEventExchangeInitializer {
    private static final Logger log = LoggerFactory.getLogger(ProducedEventExchangeInitializer.class);
    private final ExchangeDeclarator exchangeDeclarator;
    private final List<ProducerDefinedExchange> producerDefinedExchanges;

    @Inject
    public ProducedEventExchangeInitializer(ExchangeDeclarator exchangeDeclarator) {
        this.exchangeDeclarator = exchangeDeclarator;
        this.producerDefinedExchanges = new ArrayList<ProducerDefinedExchange>();
    }

    public void addProducerDefinedExchange(String exchange, ExchangeType exchangeType, Scope scope) {
        if (log.isTraceEnabled()) {
            log.trace("Adding producer defined exchange {}", (Object)exchange);
        }
        this.producerDefinedExchanges.add(new ProducerDefinedExchange(exchange, exchangeType, scope));
    }

    public List<ProducerDefinedExchange> getProducerDefinedExchanges() {
        return this.producerDefinedExchanges;
    }

    public void initExchanges() {
        this.producerDefinedExchanges.forEach(exchange -> {
            try {
                this.exchangeDeclarator.declareExchange(exchange.exchangeName(), exchange.type(), exchange.scope().equals((Object)Scope.FRONTEND));
            }
            catch (IOException e) {
                log.error("Could not get or create channel while initializing producer defined exchange", (Throwable)e);
                throw new RuntimeException("Could not get or create channel while initializing producer defined exchange", e);
            }
        });
    }
}

