/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.producer;

import java.util.Objects;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Scope;

public final class RoutingDetails {
    private final String eventName;
    private final String exchange;
    private final ExchangeType exchangeType;
    private final String routingKey;
    private final Scope scope;
    private final String userId;
    private final String subscriptionId;
    private final boolean persistent;
    private final Integer cacheTtl;
    private final boolean propagate;

    public RoutingDetails(String eventName, String exchange, ExchangeType exchangeType, String routingKey, Scope scope, String userId, String subscriptionId, boolean persistent, Integer cacheTtl, boolean propagate) {
        this.eventName = eventName;
        this.exchange = exchange;
        this.exchangeType = exchangeType;
        this.routingKey = routingKey;
        this.scope = scope;
        this.userId = userId;
        this.subscriptionId = subscriptionId;
        this.persistent = persistent;
        this.cacheTtl = cacheTtl;
        this.propagate = propagate;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getExchange() {
        return this.exchange;
    }

    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public Integer getCacheTtl() {
        return this.cacheTtl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean getPropagate() {
        return this.propagate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingDetails that = (RoutingDetails)o;
        return this.persistent == that.persistent && Objects.equals(this.eventName, that.eventName) && Objects.equals(this.exchange, that.exchange) && this.exchangeType == that.exchangeType && Objects.equals(this.routingKey, that.routingKey) && this.scope == that.scope && Objects.equals(this.userId, that.userId) && Objects.equals(this.subscriptionId, that.subscriptionId) && Objects.equals(this.cacheTtl, that.cacheTtl);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.exchange, this.exchangeType, this.routingKey, this.scope, this.userId, this.subscriptionId, this.persistent, this.cacheTtl);
    }

    public static class MiscRoutingDetailsBuilder {
        private final String eventName;
        private final String exchange;
        private final ExchangeType exchangeType;
        private final String routingKey;
        private final Scope scope;
        private String userId;
        private String sessionId;
        private String subscriptionId;
        private boolean persistent;
        private Integer cacheTtl;
        private boolean propagate;

        public MiscRoutingDetailsBuilder(String eventName, String exchange, ExchangeType exchangeType, String routingKey, Scope scope, boolean propagate) {
            this.eventName = eventName;
            this.exchange = exchange;
            this.exchangeType = exchangeType;
            this.routingKey = routingKey;
            this.scope = scope;
            this.propagate = propagate;
        }

        public MiscRoutingDetailsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public MiscRoutingDetailsBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public MiscRoutingDetailsBuilder persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public MiscRoutingDetailsBuilder cacheTtl(Integer cacheTtl) {
            this.cacheTtl = cacheTtl;
            return this;
        }

        public MiscRoutingDetailsBuilder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public RoutingDetails build() {
            return new RoutingDetails(this.eventName, this.exchange, this.exchangeType, this.routingKey, this.scope, this.userId, this.subscriptionId, this.persistent, this.cacheTtl, this.propagate);
        }
    }

    public static class ScopeBuilder {
        private final String eventName;
        private final String exchange;
        private final ExchangeType exchangeType;
        private final String routingKey;

        public ScopeBuilder(String eventName, String exchange, ExchangeType exchangeType, String routingKey) {
            this.eventName = eventName;
            this.exchange = exchange;
            this.exchangeType = exchangeType;
            this.routingKey = routingKey;
        }

        public MiscRoutingDetailsBuilder scope(Scope scope) {
            return new MiscRoutingDetailsBuilder(this.eventName, this.exchange, this.exchangeType, this.routingKey, scope, true);
        }
    }

    public static class RoutingKeyBuilder {
        private final String eventName;
        private final String exchange;
        private final ExchangeType exchangeType;

        public RoutingKeyBuilder(String eventName, String exchange, ExchangeType exchangeType) {
            this.eventName = eventName;
            this.exchange = exchange;
            this.exchangeType = exchangeType;
        }

        public ScopeBuilder routingKey(String routingKey) {
            return new ScopeBuilder(this.eventName, this.exchange, this.exchangeType, routingKey);
        }
    }

    public static class ExchangeTypeBuilder {
        private final String eventName;
        private final String exchange;

        public ExchangeTypeBuilder(String eventName, String exchange) {
            this.eventName = eventName;
            this.exchange = exchange;
        }

        public RoutingKeyBuilder exchangeType(ExchangeType exchangeType) {
            return new RoutingKeyBuilder(this.eventName, this.exchange, exchangeType);
        }
    }

    public static class ExchangeBuilder {
        private final String eventName;

        protected ExchangeBuilder(String eventName) {
            this.eventName = eventName;
        }

        public ExchangeTypeBuilder exchange(String exchange) {
            return new ExchangeTypeBuilder(this.eventName, exchange);
        }
    }

    public static class Builder {
        public ExchangeBuilder eventName(String eventName) {
            return new ExchangeBuilder(eventName);
        }
    }
}

