/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.health;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
@Default
public class IrisReadinessCheck
implements HealthCheck {
    private final ReadinessStatus readinessStatus = new ReadinessStatus(new AtomicBoolean(false), new AtomicBoolean(false), new AtomicBoolean(false));

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Iris amqp connection readiness check").withData("connecting", this.readinessStatus.connecting().get()).withData("timedOut", this.readinessStatus.timedOut().get()).up();
        if (this.readinessStatus.isHealthy().get()) {
            return builder.build();
        }
        return builder.down().build();
    }

    public void setConnecting(boolean connecting) {
        this.readinessStatus.connecting().set(connecting);
        this.readinessStatus.isHealthy().set(this.getHealth(this.readinessStatus));
    }

    public void setTimedOut(boolean timedOut) {
        this.readinessStatus.timedOut().set(timedOut);
        this.readinessStatus.isHealthy().set(this.getHealth(this.readinessStatus));
    }

    private boolean getHealth(ReadinessStatus readinessStatus) {
        return !readinessStatus.timedOut().get() && !readinessStatus.connecting().get();
    }

    public record ReadinessStatus(AtomicBoolean isHealthy, AtomicBoolean connecting, AtomicBoolean timedOut) {
    }
}

