/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime;

import com.rabbitmq.client.AMQP;
import io.quarkus.arc.Arc;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Optional;
import org.iris_events.annotations.Scope;
import org.iris_events.common.DeliveryMode;
import org.iris_events.context.EventContext;
import org.iris_events.exception.IrisSendException;
import org.iris_events.producer.CorrelationIdProvider;
import org.iris_events.producer.RoutingDetails;
import org.iris_events.runtime.EventAppInfoProvider;
import org.iris_events.runtime.InstanceInfoProvider;
import org.iris_events.runtime.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BasicPropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(BasicPropertiesProvider.class);
    @Inject
    EventAppInfoProvider eventAppInfoProvider;
    @Inject
    EventContext eventContext;
    @Inject
    CorrelationIdProvider correlationIdProvider;
    @Inject
    InstanceInfoProvider instanceInfoProvider;
    @Inject
    TimestampProvider timestampProvider;
    @Context
    HttpHeaders httpHeaders;

    @ActivateRequestContext
    public AMQP.BasicProperties getOrCreateAmqpBasicProperties(RoutingDetails routingDetails) {
        String serviceId = this.eventAppInfoProvider.getApplicationId();
        AMQP.BasicProperties basicProperties = this.eventContext.getAmqpBasicProperties();
        if (basicProperties == null) {
            log.debug("No basic properties found within eventContext - building new one.");
            basicProperties = this.createAmqpBasicProperties(serviceId);
        }
        return this.buildAmqpBasicPropertiesWithCustomHeaders(basicProperties, serviceId, routingDetails);
    }

    private AMQP.BasicProperties createAmqpBasicProperties(String serviceId) {
        CurrentVertxRequest activeRequest = (CurrentVertxRequest)Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get();
        String correlationId = Optional.ofNullable(activeRequest.getCurrent()).map(ctx -> this.httpHeaders.getHeaderString("x-request-id")).orElseGet(this.correlationIdProvider::getCorrelationId);
        log.debug("Creating new AMQP.BasicProperties with correlationId: {}", (Object)correlationId);
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder().correlationId(correlationId);
        HashMap headers = new HashMap();
        Optional.ofNullable(serviceId).ifPresent(id -> headers.put("x-origin-service-id", serviceId));
        builder.headers(headers);
        return builder.build();
    }

    private AMQP.BasicProperties buildAmqpBasicPropertiesWithCustomHeaders(AMQP.BasicProperties basicProperties, String serviceId, RoutingDetails routingDetails) {
        String eventName = routingDetails.getEventName();
        Scope scope = routingDetails.getScope();
        String userId = routingDetails.getUserId();
        String sessionId = routingDetails.getSessionId();
        boolean propagate = routingDetails.getPropagate();
        String subscriptionId = routingDetails.getSubscriptionId();
        Integer cacheTtl = routingDetails.getCacheTtl();
        String hostName = this.instanceInfoProvider.getInstanceName();
        HashMap<String, Object> headers = new HashMap<String, Object>(Optional.ofNullable(basicProperties.getHeaders()).orElse(new HashMap()));
        Object currentUserId = headers.get("x-user-id");
        Optional.ofNullable(serviceId).ifPresent(id -> headers.put("x-current-service-id", serviceId));
        headers.put("x-instance-id", hostName);
        headers.put("x-event-type", eventName);
        headers.put("x-server-timestamp", this.timestampProvider.getCurrentTimestamp());
        Optional.ofNullable(subscriptionId).ifPresent(id -> headers.put("x-subscription-id", id));
        Optional.ofNullable(sessionId).ifPresent(sId -> headers.put("x-session-id", sId));
        Optional.ofNullable(cacheTtl).ifPresent(ttl -> headers.put("x-cache-ttl", ttl));
        if (scope != Scope.INTERNAL) {
            headers.remove("x-jwt");
        }
        if (userId != null) {
            headers.put("x-user-id", userId);
            if (currentUserId != null && !currentUserId.equals(userId)) {
                headers.put("x-origin-service-id", serviceId);
                headers.remove("x-jwt");
                headers.remove("x-router");
                headers.remove("x-client-version");
                headers.remove("x-session-id");
            }
        }
        if (scope == Scope.USER) {
            if (!headers.containsKey("x-user-id")) {
                throw new IrisSendException("Can not send USER scoped message without userId available from existing context or being provided as argument to send method.");
            }
            headers.remove("x-router");
        }
        AMQP.BasicProperties.Builder builder = basicProperties.builder();
        builder.deliveryMode(Integer.valueOf(this.getDeliveryMode(routingDetails)));
        if (!propagate) {
            String correlationId = this.correlationIdProvider.getCorrelationId();
            log.debug("CorrelationId propagation was purposely broken - resetting correlationId to: {}", (Object)correlationId);
            builder.correlationId(correlationId);
        }
        return builder.headers(headers).build();
    }

    private int getDeliveryMode(RoutingDetails routingDetails) {
        return routingDetails.getPersistent() ? DeliveryMode.PERSISTENT.getValue() : DeliveryMode.NON_PERSISTENT.getValue();
    }
}

