/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.recorder;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;
import org.iris_events.consumer.ConsumerContainer;
import org.iris_events.context.IrisContext;
import org.iris_events.context.MethodHandleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class MethodHandleRecorder {
    private static final Logger log = LoggerFactory.getLogger(MethodHandleRecorder.class);

    public void registerConsumer(BeanContainer beanContainer, MethodHandleContext methodHandleContext, IrisContext irisContext) throws NoSuchMethodException, IllegalAccessException, IOException {
        Object eventHandlerInstance = beanContainer.beanInstance(methodHandleContext.getHandlerClass(), new Annotation[0]);
        ((ConsumerContainer)beanContainer.beanInstance(ConsumerContainer.class, new Annotation[0])).addConsumer(this.createMethodHandle(methodHandleContext), methodHandleContext, irisContext, eventHandlerInstance);
    }

    public void registerFrontendCallback(BeanContainer beanContainer, MethodHandleContext methodHandleContext, IrisContext irisContext) throws NoSuchMethodException, IllegalAccessException, IOException {
        Object eventHandlerInstance = beanContainer.beanInstance(methodHandleContext.getHandlerClass(), new Annotation[0]);
        ((ConsumerContainer)beanContainer.beanInstance(ConsumerContainer.class, new Annotation[0])).addFrontendCallback(this.createMethodHandle(methodHandleContext), methodHandleContext, irisContext, eventHandlerInstance);
    }

    private MethodHandle createMethodHandle(MethodHandleContext methodHandleContext) throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        Optional<Class<?>> optionalReturnEventClass = Optional.ofNullable(methodHandleContext.getReturnEventClass());
        Class<Void> returnType = optionalReturnEventClass.isPresent() ? optionalReturnEventClass.get() : Void.TYPE;
        MethodType methodType = MethodType.methodType(returnType, methodHandleContext.getEventClass());
        return publicLookup.findVirtual(methodHandleContext.getHandlerClass(), methodHandleContext.getMethodName(), methodType);
    }
}

