/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.iris_events.auth.IrisJwtValidator;
import org.iris_events.consumer.Consumer;
import org.iris_events.consumer.DeliverCallbackProvider;
import org.iris_events.consumer.ExchangeDeclarator;
import org.iris_events.consumer.FrontendEventConsumer;
import org.iris_events.consumer.QueueDeclarator;
import org.iris_events.context.EventContext;
import org.iris_events.context.IrisContext;
import org.iris_events.context.MethodHandleContext;
import org.iris_events.exception.IrisConnectionException;
import org.iris_events.producer.EventProducer;
import org.iris_events.routing.RoutingDetailsProvider;
import org.iris_events.runtime.ExchangeNameProvider;
import org.iris_events.runtime.InstanceInfoProvider;
import org.iris_events.runtime.IrisExceptionHandler;
import org.iris_events.runtime.QueueNameProvider;
import org.iris_events.runtime.channel.ChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConsumerContainer {
    private static final Logger log = LoggerFactory.getLogger(ConsumerContainer.class);
    private final ObjectMapper objectMapper;
    private final EventContext eventContext;
    private final Map<String, Consumer> consumerMap;
    private final ChannelService consumerChannelService;
    private final EventProducer producer;
    private final QueueNameProvider queueNameProvider;
    private final ExchangeNameProvider exchangeNameProvider;
    private final IrisJwtValidator jwtValidator;
    private final FrontendEventConsumer frontendEventConsumer;
    private final IrisExceptionHandler errorHandler;
    private final QueueDeclarator queueDeclarator;
    private final ExchangeDeclarator exchangeDeclarator;
    private final InstanceInfoProvider instanceInfoProvider;
    private final RoutingDetailsProvider routingDetailsProvider;

    @Inject
    public ConsumerContainer(ObjectMapper objectMapper, EventContext eventContext, @Named(value="consumerChannelService") ChannelService consumerChannelService, EventProducer producer, QueueNameProvider queueNameProvider, ExchangeNameProvider exchangeNameProvider, Instance<IrisJwtValidator> jwtValidator, FrontendEventConsumer frontendEventConsumer, IrisExceptionHandler errorHandler, QueueDeclarator queueDeclarator, ExchangeDeclarator exchangeDeclarator, InstanceInfoProvider instanceInfoProvider, RoutingDetailsProvider routingDetailsProvider) {
        this.consumerChannelService = consumerChannelService;
        this.queueNameProvider = queueNameProvider;
        this.exchangeNameProvider = exchangeNameProvider;
        this.jwtValidator = jwtValidator.stream().findAny().orElse(null);
        this.errorHandler = errorHandler;
        this.queueDeclarator = queueDeclarator;
        this.exchangeDeclarator = exchangeDeclarator;
        this.consumerMap = new HashMap<String, Consumer>();
        this.objectMapper = objectMapper;
        this.eventContext = eventContext;
        this.producer = producer;
        this.frontendEventConsumer = frontendEventConsumer;
        this.instanceInfoProvider = instanceInfoProvider;
        this.routingDetailsProvider = routingDetailsProvider;
    }

    public void initConsumers() {
        this.consumerMap.forEach((queueName, consumer) -> {
            try {
                consumer.initChannel();
            }
            catch (Exception e) {
                String msg = String.format("Could not initialize consumer for exchange: '%s' queue '%s'", consumer.getContext().getName(), queueName);
                log.error(msg, (Throwable)e);
                throw new IrisConnectionException(msg, (Throwable)e);
            }
        });
    }

    public void addConsumer(MethodHandle methodHandle, MethodHandleContext methodHandleContext, IrisContext irisContext, Object eventHandlerInstance) {
        DeliverCallbackProvider deliverCallbackProvider = new DeliverCallbackProvider(this.objectMapper, this.producer, irisContext, this.eventContext, eventHandlerInstance, methodHandle, methodHandleContext, this.jwtValidator, this.errorHandler, this.routingDetailsProvider);
        this.consumerMap.put(UUID.randomUUID().toString(), new Consumer(irisContext, this.consumerChannelService, deliverCallbackProvider, this.queueNameProvider, this.exchangeNameProvider, this.queueDeclarator, this.exchangeDeclarator));
    }

    public void addFrontendCallback(MethodHandle methodHandle, MethodHandleContext methodHandleContext, IrisContext irisContext, Object eventHandlerInstance) {
        DeliverCallbackProvider deliverCallbackProvider = new DeliverCallbackProvider(this.objectMapper, this.producer, irisContext, this.eventContext, eventHandlerInstance, methodHandle, methodHandleContext, this.jwtValidator, this.errorHandler, this.routingDetailsProvider);
        this.frontendEventConsumer.addDeliverCallbackProvider(this.getFrontendRoutingKey(irisContext), deliverCallbackProvider);
    }

    private String getFrontendRoutingKey(IrisContext irisContext) {
        return Optional.ofNullable(irisContext.getBindingKeys()).map(strings -> (String)strings.get(0)).orElse(irisContext.getName());
    }
}

