/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.consumer;

import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.UUID;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.runtime.channel.ChannelService;

@ApplicationScoped
public class ExchangeDeclarator {
    final ChannelService channelService;
    private final String channelId;

    @Inject
    public ExchangeDeclarator(@Named(value="producerChannelService") ChannelService channelService) {
        this.channelService = channelService;
        this.channelId = UUID.randomUUID().toString();
    }

    public void declareExchange(String exchange, ExchangeType exchangeType, boolean isFrontend) throws IOException {
        Channel channel = this.channelService.getOrCreateChannelById(this.channelId);
        if (isFrontend) {
            channel.exchangeDeclare(exchange, BuiltinExchangeType.TOPIC, false);
        } else {
            BuiltinExchangeType type = BuiltinExchangeType.valueOf((String)exchangeType.name());
            channel.exchangeDeclare(exchange, type, true);
        }
    }
}

