/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.health;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
@Default
public class IrisLivenessCheck
implements HealthCheck {
    private final LivenessStatus livenessStatus = new LivenessStatus(new AtomicBoolean(false), new AtomicBoolean(false));

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Iris amqp connection health check").withData("timedOut", this.livenessStatus.timedOut().get()).up();
        if (this.livenessStatus.isHealthy().get()) {
            return builder.build();
        }
        return builder.down().build();
    }

    public void setTimedOut(boolean timedOut) {
        this.livenessStatus.timedOut().set(timedOut);
        this.livenessStatus.isHealthy().set(this.getHealth(this.livenessStatus));
    }

    private boolean getHealth(LivenessStatus livenessStatus) {
        return !livenessStatus.timedOut().get();
    }

    public record LivenessStatus(AtomicBoolean isHealthy, AtomicBoolean timedOut) {
    }
}

