/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Objects;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.common.Queues;
import org.iris_events.context.IrisContext;
import org.iris_events.runtime.InstanceInfoProvider;

@ApplicationScoped
public class QueueNameProvider {
    final String applicationName;
    final String instanceName;

    @Inject
    public QueueNameProvider(InstanceInfoProvider instanceInfoProvider) {
        this.applicationName = instanceInfoProvider.getApplicationName();
        this.instanceName = instanceInfoProvider.getInstanceName();
    }

    public String getQueueName(IrisContext context) {
        String name = context.getName();
        if (context.isRpc()) {
            return this.getRpcRequestQueueName(name);
        }
        ExchangeType exchangeType = context.getExchangeType();
        StringBuilder stringBuffer = new StringBuilder().append(this.applicationName).append(".").append(name);
        if (context.isConsumerOnEveryInstance() && Objects.nonNull(this.instanceName) && !this.instanceName.isBlank()) {
            stringBuffer.append(".").append(this.instanceName);
        }
        if (exchangeType == ExchangeType.DIRECT || exchangeType == ExchangeType.TOPIC) {
            String bindingKeys = String.join((CharSequence)"-", context.getBindingKeys());
            stringBuffer.append(".").append(bindingKeys);
        }
        return stringBuffer.toString();
    }

    public String getFrontendQueueName() {
        return String.format("%s.%s", this.applicationName, Queues.FRONTEND_SUFFIX.getValue());
    }

    public String getRpcRequestQueueName(String eventName) {
        return String.format("%s-%s.rpc.req", eventName, this.instanceName);
    }

    public String getRpcResponseQueueName(String eventName) {
        return String.format("%s-%s.rpc.res", eventName, this.instanceName);
    }
}

