/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.connection;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.RecoverableConnection;
import com.rabbitmq.client.RecoveryListener;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iris_events.exception.IrisConnectionException;
import org.iris_events.health.IrisLivenessCheck;
import org.iris_events.health.IrisReadinessCheck;
import org.iris_events.runtime.InstanceInfoProvider;
import org.iris_events.runtime.configuration.IrisConfig;
import org.iris_events.runtime.connection.ConnectionFactoryProvider;
import org.slf4j.Logger;

public abstract class AbstractConnectionProvider
implements RecoveryListener {
    private ConnectionFactoryProvider connectionFactoryProvider;
    private InstanceInfoProvider instanceInfoProvider;
    private IrisConfig config;
    private IrisReadinessCheck readinessCheck;
    private IrisLivenessCheck livenessCheck;
    private Logger log;
    private AtomicBoolean connecting;
    protected Connection connection;

    public AbstractConnectionProvider() {
    }

    public AbstractConnectionProvider(ConnectionFactoryProvider connectionFactoryProvider, InstanceInfoProvider instanceInfoProvider, IrisConfig config, IrisReadinessCheck readinessCheck, IrisLivenessCheck livenessCheck, Logger log) {
        this.connectionFactoryProvider = connectionFactoryProvider;
        this.instanceInfoProvider = instanceInfoProvider;
        this.config = config;
        this.readinessCheck = readinessCheck;
        this.livenessCheck = livenessCheck;
        this.log = log;
        this.connecting = new AtomicBoolean(false);
    }

    public synchronized Connection getConnection() {
        if (this.isConnectionOpen() || this.isConnecting()) {
            return this.connection;
        }
        this.log.info("Establishing new AMQP connection with resilience.");
        this.setConnecting(true);
        this.connect();
        if (this.connection instanceof RecoverableConnection) {
            ((RecoverableConnection)this.connection).addRecoveryListener((RecoveryListener)this);
        }
        return this.connection;
    }

    protected abstract String getConnectionNamePrefix();

    private void connect() {
        try {
            String connectionName = this.getConnectionNamePrefix() + this.instanceInfoProvider.getInstanceName();
            this.connection = this.connectionFactoryProvider.getConnectionFactory().newConnection(connectionName);
            this.setConnecting(false);
            this.setTimedOut(false);
        }
        catch (IOException | TimeoutException e) {
            throw new IrisConnectionException("Could not create new AMQP connection", (Throwable)e);
        }
    }

    protected void setConnecting(boolean connecting) {
        this.connecting.set(connecting);
        this.readinessCheck.setConnecting(connecting);
    }

    protected void setTimedOut(boolean timedOut) {
        this.readinessCheck.setTimedOut(timedOut);
        this.livenessCheck.setTimedOut(timedOut);
    }

    private boolean isConnecting() {
        return this.connecting.get();
    }

    private boolean isConnectionOpen() {
        return this.connection != null && this.connection.isOpen();
    }
}

