/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.connection;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.RecoveryDelayHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.iris_events.exception.IrisConnectionFactoryException;
import org.iris_events.runtime.configuration.IrisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConnectionFactoryProvider
implements RecoveryDelayHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactoryProvider.class);
    private final IrisConfig config;
    private ConnectionFactory connectionFactory;

    @Inject
    public ConnectionFactoryProvider(IrisConfig config) {
        this.config = config;
    }

    public ConnectionFactory getConnectionFactory() {
        return Optional.ofNullable(this.connectionFactory).orElseGet(() -> {
            ConnectionFactory connectionFactory;
            this.connectionFactory = connectionFactory = this.buildConnectionFactory(this.config);
            return connectionFactory;
        });
    }

    private ConnectionFactory buildConnectionFactory(IrisConfig config) {
        int port = config.getPort();
        String vhost = config.virtualHost();
        log.info("Iris AMQP connection config: host={}, port={}, username={}, ssl={}", new Object[]{config.host(), port, config.username(), config.isSsl()});
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUsername(config.username());
            connectionFactory.setPassword(config.password());
            connectionFactory.setHost(config.host());
            connectionFactory.setPort(port);
            connectionFactory.setVirtualHost(vhost);
            connectionFactory.setAutomaticRecoveryEnabled(true);
            connectionFactory.setRecoveryDelayHandler((RecoveryDelayHandler)this);
            if (config.isSsl()) {
                connectionFactory.useSslProtocol(SSLContext.getDefault());
                connectionFactory.enableHostnameVerification();
            }
            return connectionFactory;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Could not create AMQP ConnectionFactory!", (Throwable)e);
            throw new IrisConnectionFactoryException("Could not create AMQP ConnectionFactory", (Throwable)e);
        }
    }

    public long getDelay(int recoveryAttempts) {
        long backoffIntervalMillis = this.config.backoffMaxIntervalMillis();
        double backoffMultiplier = this.config.backoffMultiplier();
        return (long)Math.min((double)backoffIntervalMillis * backoffMultiplier * (double)recoveryAttempts, 30000.0);
    }
}

