/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.CertUtils;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;

public class X509CRLHolder {
    private CertificateList x509CRL;
    private X509Extensions extensions;

    private static CertificateList parseBytes(byte[] crlEncoding) throws IOException {
        try {
            return CertificateList.getInstance((Object)ASN1Object.fromByteArray((byte[])crlEncoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public X509CRLHolder(byte[] crlEncoding) throws IOException {
        this(X509CRLHolder.parseBytes(crlEncoding));
    }

    public X509CRLHolder(CertificateList x509CRL) {
        this.x509CRL = x509CRL;
        this.extensions = x509CRL.getTBSCertList().getExtensions();
    }

    public byte[] getEncoded() throws IOException {
        return this.x509CRL.getEncoded();
    }

    public X500Name getIssuer() {
        return X500Name.getInstance((Object)this.x509CRL.getIssuer());
    }

    public X509CRLEntryHolder getRevokedCertificate(BigInteger serialNumber) {
        Enumeration en = this.x509CRL.getRevokedCertificateEnumeration();
        while (en.hasMoreElements()) {
            TBSCertList.CRLEntry entry = (TBSCertList.CRLEntry)en.nextElement();
            if (!entry.getUserCertificate().getValue().equals(serialNumber)) continue;
            return new X509CRLEntryHolder(entry);
        }
        return null;
    }

    public Collection getRevokedCertificates() {
        TBSCertList.CRLEntry[] entries = this.x509CRL.getRevokedCertificates();
        ArrayList<X509CRLEntryHolder> l = new ArrayList<X509CRLEntryHolder>(entries.length);
        Enumeration en = this.x509CRL.getRevokedCertificateEnumeration();
        while (en.hasMoreElements()) {
            TBSCertList.CRLEntry entry = (TBSCertList.CRLEntry)en.nextElement();
            l.add(new X509CRLEntryHolder(entry));
        }
        return l;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public X509Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return CertUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return CertUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return CertUtils.getNonCriticalExtensionOIDs(this.extensions);
    }

    public CertificateList toASN1Structure() {
        return this.x509CRL;
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws CertException {
        ContentVerifier verifier;
        TBSCertList tbsCRL = this.x509CRL.getTBSCertList();
        if (!tbsCRL.getSignature().equals((Object)this.x509CRL.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            verifier = verifierProvider.get(tbsCRL.getSignature());
            OutputStream sOut = verifier.getOutputStream();
            sOut.write(tbsCRL.getDEREncoded());
            sOut.close();
        }
        catch (Exception e) {
            throw new CertException("unable to process signature: " + e.getMessage(), e);
        }
        return verifier.verify(this.x509CRL.getSignature().getBytes());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509CRLHolder)) {
            return false;
        }
        X509CRLHolder other = (X509CRLHolder)o;
        return this.x509CRL.equals((Object)other.x509CRL);
    }

    public int hashCode() {
        return this.x509CRL.hashCode();
    }
}

