/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        BERConstructedOctetString encContent;
        AlgorithmIdentifier encAlgId;
        SecretKey encKey;
        Provider encProvider = keyGen.getProvider();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        try {
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(encryptionOID, encProvider);
            encKey = keyGen.generateKey();
            AlgorithmParameters params = this.generateParameters(encryptionOID, encKey, encProvider);
            cipher.init(1, (Key)encKey, params, this.rand);
            if (params == null) {
                params = cipher.getParameters();
            }
            encAlgId = this.getAlgorithmIdentifier(encryptionOID, params);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            CipherOutputStream cOut = new CipherOutputStream(bOut, cipher);
            content.write(cOut);
            cOut.close();
            encContent = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
        for (Object recipient : this.oldRecipientInfoGenerators) {
            try {
                recipientInfos.add((DEREncodable)recipient.generate(encKey, this.rand, provider));
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        for (Object recipient : this.recipientInfoGenerators) {
            recipientInfos.add((DEREncodable)recipient.generate(new GenericKey(encKey)));
        }
        EncryptedContentInfo eci = content instanceof CMSTypedData ? new EncryptedContentInfo((DERObjectIdentifier)((CMSTypedData)content).getContentType(), encAlgId, (ASN1OctetString)encContent) : new EncryptedContentInfo((DERObjectIdentifier)CMSObjectIdentifiers.data, encAlgId, (ASN1OctetString)encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), eci, (ASN1Set)unprotectedAttrSet));
        return new CMSEnvelopedData(contentInfo);
    }

    private CMSEnvelopedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BERConstructedOctetString encContent = new BERConstructedOctetString(encryptedContent);
        GenericKey encKey = contentEncryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add((DEREncodable)recipient.generate(encKey));
        }
        EncryptedContentInfo eci = new EncryptedContentInfo((DERObjectIdentifier)content.getContentType(), encAlgId, (ASN1OctetString)encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), eci, (ASN1Set)unprotectedAttrSet));
        return new CMSEnvelopedData(contentInfo);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, encryptionOID, CMSUtils.getProvider(provider));
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(this.rand);
        return this.generate(content, encryptionOID, keyGen, provider);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, encryptionOID, keySize, CMSUtils.getProvider(provider));
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(keySize, this.rand);
        return this.generate(content, encryptionOID, keyGen, provider);
    }

    public CMSEnvelopedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

