/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSAuthenticatedDataParser;
import org.bouncycastle.cms.CMSAuthenticatedDataStreamGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class NewAuthenticatedDataStreamTest
extends TestCase {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origEcKP;
    private static KeyPair _reciEcKP;
    private static X509Certificate _reciEcCert;
    private static boolean _initialised;
    public boolean DEBUG = true;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _origEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcCert = CMSTestUtil.makeCertificate(_reciEcKP, _reciDN, _signKP, _signDN);
        }
    }

    public void setUp() throws Exception {
        NewAuthenticatedDataStreamTest.init();
    }

    public NewAuthenticatedDataStreamTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(NewAuthenticatedDataStreamTest.class);
    }

    public static Test suite() throws Exception {
        NewAuthenticatedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(NewAuthenticatedDataStreamTest.class));
    }

    public void testKeyTransDESede() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.DES_EDE3_CBC);
    }

    public void testKeyTransDESedeWithDigest() throws Exception {
        this.tryKeyTransWithDigest(CMSAlgorithm.DES_EDE3_CBC);
    }

    private void tryKeyTrans(ASN1ObjectIdentifier macAlg) throws Exception {
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        adGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open(bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build());
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray());
        RecipientInformationStore recipients = ad.getRecipientInfos();
        NewAuthenticatedDataStreamTest.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        NewAuthenticatedDataStreamTest.assertEquals((int)1, (int)c.size());
        for (RecipientInformation recipient : c) {
            NewAuthenticatedDataStreamTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(data, recData));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
        }
    }

    private void tryKeyTransWithDigest(ASN1ObjectIdentifier macAlg) throws Exception {
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DigestCalculatorProvider calcProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        adGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open((OutputStream)bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build(), calcProvider.get(new AlgorithmIdentifier((DERObjectIdentifier)OIWObjectIdentifiers.idSHA1)));
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray(), calcProvider);
        RecipientInformationStore recipients = ad.getRecipientInfos();
        NewAuthenticatedDataStreamTest.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        NewAuthenticatedDataStreamTest.assertEquals((int)1, (int)c.size());
        for (RecipientInformation recipient : c) {
            NewAuthenticatedDataStreamTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(data, recData));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getContentDigest(), recipient.getContentDigest()));
        }
    }

    static {
        _initialised = false;
    }
}

